/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import migratedb.v1.scanner.PathTarget;
import migratedb.v1.scanner.ScanResult;
import migratedb.v1.scanner.Scanner;
import migratedb.v1.scanner.Target;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.checkerframework.checker.nullness.qual.Nullable;

@Mojo(name="scan", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Parameter
    public @Nullable String[] includes = new String[]{"db/migration"};
    @Parameter(defaultValue="false")
    public boolean includeDependencies = false;
    @Parameter(defaultValue="true")
    public boolean failBuildOnUnprocessableClassPathElement = true;
    @Parameter(defaultValue="false")
    public boolean followSymlinks = false;
    @Parameter(defaultValue="${project.build.outputDirectory}/db/migration")
    public File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Path> classPath = this.getProjectClassPath();
        ArrayList<Path> unprocessableClassPathElements = new ArrayList<Path>();
        Scanner scanner = new Scanner(unprocessable -> {
            unprocessableClassPathElements.add((Path)unprocessable);
            return Unit.INSTANCE;
        });
        ScanResult scanResult = scanner.scan(this.crateScannerConfig(classPath));
        this.getLog().info((CharSequence)("Found " + scanResult.getFoundClasses().size() + " classes, " + scanResult.getFoundResources().size() + " resources"));
        PathTarget target = new PathTarget(this.outputDirectory.toPath(), true);
        try {
            scanResult.writeTo((Target)target);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write scan result to " + target, (Exception)e);
        }
        this.handle(unprocessableClassPathElements);
    }

    private Scanner.Config crateScannerConfig(Set<Path> classPath) {
        return new Scanner.Config(classPath, new LinkedHashSet<String>(Arrays.asList(this.includes)), it -> true, this.followSymlinks);
    }

    private void handle(List<Path> unprocessableClassPathElements) throws MojoFailureException {
        if (!unprocessableClassPathElements.isEmpty()) {
            StringBuilder message = new StringBuilder("The project class path contains elements that couldn't be scanned:\n");
            unprocessableClassPathElements.forEach(it -> message.append(it).append("\n"));
            if (this.failBuildOnUnprocessableClassPathElement) {
                throw new MojoFailureException(message.toString());
            }
            this.getLog().warn((CharSequence)message);
        }
    }

    private Set<Path> getProjectClassPath() throws MojoExecutionException {
        try {
            return (this.includeDependencies ? this.project.getRuntimeClasspathElements() : List.of(this.project.getBuild().getOutputDirectory())).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        }
        catch (InvalidPathException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to get project class path", (Exception)e);
        }
    }
}

