/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static String trimChar(String s, char c) {
        int end;
        int start;
        for (start = 0; start < s.length() && s.charAt(start) == c; ++start) {
        }
        for (end = s.length() - 1; end >= 0 && s.charAt(end) == c; --end) {
        }
        if (start >= end) {
            return "";
        }
        return s.substring(start, end + 1);
    }

    public static String trimOrPad(String str, int length) {
        return StringUtils.trimOrPad(str, length, ' ');
    }

    public static String trimOrPad(String str, int length, char padChar) {
        StringBuilder result = str == null ? new StringBuilder() : new StringBuilder(str);
        if (result.length() > length) {
            return result.substring(0, length);
        }
        while (result.length() < length) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static String replaceAll(String str, String originalToken, String replacementToken) {
        return str.replaceAll(Pattern.quote(originalToken), Matcher.quoteReplacement(replacementToken));
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        List<String> tokens = StringUtils.tokenizeToStringCollection(str, delimiters);
        return tokens.toArray(new String[0]);
    }

    public static List<String> tokenizeToStringCollection(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>(str.length() / 5);
        char[] delimiterChars = delimiters.toCharArray();
        int start = 0;
        int end = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean delimiter = false;
            for (char d : delimiterChars) {
                if (c != d) continue;
                tokens.add(str.substring(start, end));
                end = start = i + 1;
                delimiter = true;
                break;
            }
            if (delimiter) continue;
            if (i == start && c == ' ') {
                ++start;
                ++end;
            }
            if (i < start || c == ' ') continue;
            end = i + 1;
        }
        if (start < end) {
            tokens.add(str.substring(start, end));
        }
        return tokens;
    }

    public static boolean startsAndEndsWith(String str, String prefix, Collection<String> suffixes) {
        if (StringUtils.hasLength(prefix) && !str.startsWith(prefix)) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix) || str.length() <= (prefix + suffix).length()) continue;
            return true;
        }
        return false;
    }
}

