/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.Location;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.resource.Resource;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LocationScanner<T>
implements ClassProvider<T>,
ResourceProvider {
    private final Class<T> supertype;
    private final Collection<ResourceProvider> resourceProviders;
    private final Collection<ClassProvider<?>> classProviders;
    private Collection<Class<? extends T>> scannedClasses;

    public LocationScanner(Class<T> supertype, Collection<Location> locations, ClassLoader classLoader, boolean failOnMissingLocations) {
        this.supertype = supertype;
        this.resourceProviders = locations.stream().map(Location::resourceProvider).collect(Collectors.toUnmodifiableList());
        this.classProviders = locations.stream().map(Location::classProvider).collect(Collectors.toUnmodifiableList());
        if (failOnMissingLocations) {
            locations.stream().filter(it -> !it.exists()).findFirst().ifPresent(it -> {
                throw new MigrateDbException("Location does not exist: " + it);
            });
        }
    }

    @Override
    public Collection<Class<? extends T>> getClasses() {
        Collection result = this.scannedClasses;
        if (result == null) {
            this.scannedClasses = result = (Collection)this.classProviders.stream().flatMap(it -> it.getClasses().stream()).filter(it -> this.supertype.isAssignableFrom((Class<?>)it) && !it.isInterface() && !Modifier.isAbstract(it.getModifiers()) && Modifier.isPublic(it.getModifiers())).map(it -> it).collect(Collectors.toUnmodifiableList());
        }
        return result;
    }

    @Override
    public @Nullable Resource getResource(String name) {
        for (ResourceProvider provider : this.resourceProviders) {
            Resource resource = provider.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Collection<Resource> getResources(String prefix, Collection<String> suffixes) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (ResourceProvider provider : this.resourceProviders) {
            result.addAll(provider.getResources(prefix, suffixes));
        }
        return result;
    }
}

