/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExceptionUtils {
    public static @Nullable Throwable getRootCause(@Nullable Throwable throwable) {
        Throwable cause;
        if (throwable == null) {
            return null;
        }
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        seen.add(throwable);
        Throwable rootCause = throwable;
        while ((cause = rootCause.getCause()) != null && seen.add(cause) && seen.size() < 10000) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static String toMessage(SQLException e) {
        SQLException cause = e;
        while (cause.getNextException() != null) {
            cause = cause.getNextException();
        }
        String message = "SQL State  : " + cause.getSQLState() + "\nError Code : " + cause.getErrorCode() + "\n";
        if (cause.getMessage() != null) {
            message = message + "Message    : " + cause.getMessage().trim() + "\n";
        }
        return message;
    }
}

