/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.internal.util.StringUtils;

public class AsciiTable {
    private static final String DEFAULT_COLUMN_NAME = "(No column name)";
    private final List<String> columns;
    private final List<List<String>> rows;
    private final boolean printHeader;
    private final String nullText;
    private final String emptyText;

    public AsciiTable(List<String> columns, List<List<String>> rows, boolean printHeader, String nullText, String emptyText) {
        this.columns = AsciiTable.ensureValidColumns(columns);
        this.rows = rows;
        this.printHeader = printHeader;
        this.nullText = nullText;
        this.emptyText = emptyText;
    }

    private static List<String> ensureValidColumns(List<String> columns) {
        ArrayList<String> validColumns = new ArrayList<String>();
        for (String column : columns) {
            validColumns.add(column != null ? column : DEFAULT_COLUMN_NAME);
        }
        return validColumns;
    }

    public void render(StringBuilder result) {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (String string : this.columns) {
            widths.add(string.length());
        }
        for (List list : this.rows) {
            for (int i = 0; i < list.size(); ++i) {
                widths.set(i, Math.max((Integer)widths.get(i), this.getValue(list, i).length()));
            }
        }
        StringBuilder ruler = new StringBuilder("+");
        for (Integer width : widths) {
            ruler.append("-").append(StringUtils.trimOrPad("", width, '-')).append("-+");
        }
        ruler.append("\n");
        if (this.printHeader) {
            StringBuilder stringBuilder = new StringBuilder("|");
            for (int i = 0; i < widths.size(); ++i) {
                stringBuilder.append(" ").append(StringUtils.trimOrPad(this.columns.get(i), (Integer)widths.get(i), ' ')).append(" |");
            }
            stringBuilder.append("\n");
            result.append((CharSequence)ruler);
            result.append((CharSequence)stringBuilder);
        }
        result.append((CharSequence)ruler);
        if (this.rows.isEmpty()) {
            result.append("| ").append(StringUtils.trimOrPad(this.emptyText, ruler.length() - Math.min(ruler.length(), 5))).append(" |\n");
        } else {
            for (List<String> row : this.rows) {
                StringBuilder r = new StringBuilder("|");
                for (int i = 0; i < widths.size(); ++i) {
                    r.append(" ").append(StringUtils.trimOrPad(this.getValue(row, i), (Integer)widths.get(i), ' ')).append(" |");
                }
                r.append("\n");
                result.append((CharSequence)r);
            }
        }
        result.append((CharSequence)ruler);
    }

    private String getValue(List<String> row, int i) {
        String value = row.get(i);
        if (value == null) {
            value = this.nullText;
        }
        return value;
    }
}

