/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.sqlscript;

import java.util.HashMap;
import java.util.Map;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.internal.parser.Parser;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptMetadata;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.configuration.ConfigUtils;
import migratedb.v1.core.internal.parser.PlaceholderReplacingReader;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlScriptMetadataImpl
implements SqlScriptMetadata {
    private static final Log LOG = Log.getLog(SqlScriptMetadataImpl.class);
    private static final String EXECUTE_IN_TRANSACTION = "executeInTransaction";
    private static final String ENCODING = "encoding";
    private static final String PLACEHOLDER_REPLACEMENT = "placeholderReplacement";
    private static final String SHOULD_EXECUTE = "shouldExecute";
    private final Boolean executeInTransaction;
    private final String encoding;
    private final boolean placeholderReplacement;
    private final boolean shouldExecute;

    private SqlScriptMetadataImpl(Map<String, String> metadata) {
        HashMap<String, String> copy = new HashMap<String, String>(metadata);
        this.executeInTransaction = ConfigUtils.removeBoolean(copy, EXECUTE_IN_TRANSACTION);
        this.encoding = copy.remove(ENCODING);
        this.placeholderReplacement = Boolean.parseBoolean(copy.getOrDefault(PLACEHOLDER_REPLACEMENT, "true"));
        copy.remove(PLACEHOLDER_REPLACEMENT);
        this.shouldExecute = true;
        ConfigUtils.reportUnrecognisedProperties(copy, null);
    }

    @Override
    public Boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public boolean placeholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public boolean shouldExecute() {
        return this.shouldExecute;
    }

    public static boolean isMultilineBooleanExpression(String line) {
        return !line.startsWith(SHOULD_EXECUTE) && (line.contains("==") || line.contains("!="));
    }

    public static SqlScriptMetadata fromResource(@Nullable Resource resource, Parser parser) {
        if (resource != null) {
            LOG.debug("Found script configuration: " + resource.getName());
            return new SqlScriptMetadataImpl(ConfigUtils.loadConfiguration(PlaceholderReplacingReader.create(parser.getConfiguration(), parser.getParsingContext(), resource.read(parser.getConfiguration().getEncoding()))));
        }
        return new SqlScriptMetadataImpl(new HashMap<String, String>());
    }

    public static Resource getMetadataResource(ResourceProvider resourceProvider, Resource resource) {
        if (resourceProvider == null) {
            return null;
        }
        return resourceProvider.getResource(resource.getName() + ".conf");
    }
}

