/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.parser.Parser;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptMetadata;
import migratedb.v1.core.api.internal.sqlscript.SqlStatement;
import migratedb.v1.core.api.internal.sqlscript.SqlStatementIterator;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.sqlscript.SqlScriptMetadataImpl;

public class ParserSqlScript
implements SqlScript {
    private static final Log LOG = Log.getLog(ParserSqlScript.class);
    protected final List<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
    private int sqlStatementCount;
    private boolean nonTransactionalStatementFound;
    protected final Resource resource;
    private final SqlScriptMetadata metadata;
    protected final Parser parser;
    private final boolean mixed;
    private boolean parsed;

    public ParserSqlScript(Parser parser, Resource resource, Resource metadataResource, boolean mixed) {
        this.resource = resource;
        this.metadata = SqlScriptMetadataImpl.fromResource(metadataResource, parser);
        this.parser = parser;
        this.mixed = mixed;
    }

    protected void parse() {
        try (SqlStatementIterator sqlStatementIterator = this.parser.parse(this.resource, this.metadata);){
            boolean transactionalStatementFound = false;
            while (sqlStatementIterator.hasNext()) {
                SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                this.sqlStatements.add(sqlStatement);
                ++this.sqlStatementCount;
                if (sqlStatement.canExecuteInTransaction()) {
                    transactionalStatementFound = true;
                } else {
                    this.nonTransactionalStatementFound = true;
                }
                if (!this.mixed && transactionalStatementFound && this.nonTransactionalStatementFound && this.metadata.executeInTransaction() == null) {
                    throw new MigrateDbException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
            }
        }
        this.parsed = true;
    }

    @Override
    public void validate() {
        if (!this.parsed) {
            this.parse();
        }
    }

    @Override
    public SqlStatementIterator getSqlStatements() {
        this.validate();
        final Iterator<SqlStatement> iterator = this.sqlStatements.iterator();
        return new SqlStatementIterator(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SqlStatement next() {
                return (SqlStatement)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int getSqlStatementCount() {
        this.validate();
        return this.sqlStatementCount;
    }

    @Override
    public final Resource getResource() {
        return this.resource;
    }

    @Override
    public boolean executeInTransaction() {
        Boolean executeInTransactionOverride = this.metadata.executeInTransaction();
        if (executeInTransactionOverride != null) {
            LOG.debug("Using executeInTransaction=" + executeInTransactionOverride + " from script configuration");
            return executeInTransactionOverride;
        }
        this.validate();
        return !this.nonTransactionalStatementFound;
    }

    @Override
    public boolean shouldExecute() {
        return this.metadata.shouldExecute();
    }

    @Override
    public int compareTo(SqlScript o) {
        return this.resource.getName().compareTo(o.getResource().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{resource=" + this.resource.getName() + "}";
    }
}

