/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.sqlscript;

import java.sql.SQLException;
import migratedb.v1.core.api.internal.sqlscript.SqlStatement;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class MigrateDbSqlScriptException
extends MigrateDbSqlException {
    private final Resource resource;
    private final SqlStatement statement;

    public MigrateDbSqlScriptException(Resource resource, SqlStatement statement, SQLException sqlException) {
        super((String)(resource == null ? "Script failed" : "Migration " + resource.getName() + " failed"), sqlException);
        this.resource = resource;
        this.statement = statement;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getLineNumber() {
        return this.statement == null ? -1 : this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement == null ? "" : this.statement.getSql();
    }

    public SqlStatement getSqlStatement() {
        return this.statement;
    }

    @Override
    public String getMessage() {
        Object message = super.getMessage();
        if (this.resource != null) {
            message = (String)message + "Location   : " + this.resource.describeLocation() + "\n";
        }
        if (this.statement != null) {
            message = (String)message + "Line       : " + this.getLineNumber() + "\n";
            message = (String)message + "Statement  : " + this.getStatement() + "\n";
        }
        return message;
    }
}

