/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.schemahistory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.output.CommandResultFactory;
import migratedb.v1.core.api.output.RepairResult;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;
import migratedb.v1.core.internal.jdbc.JdbcNullTypes;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;
import org.checkerframework.checker.nullness.qual.Nullable;

class JdbcTableSchemaHistory
extends SchemaHistory {
    private static final Log LOG = Log.getLog(JdbcTableSchemaHistory.class);
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScriptFactory sqlScriptFactory;
    private final Database database;
    private final Session session;
    private final JdbcTemplate jdbcTemplate;
    private final LinkedList<AppliedMigration> cache = new LinkedList();

    JdbcTableSchemaHistory(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Table table) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScriptFactory = sqlScriptFactory;
        this.table = table;
        this.database = database;
        this.session = database.getMainSession();
        this.jdbcTemplate = this.session.getJdbcTemplate();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public boolean exists() {
        this.session.restoreOriginalState();
        return this.table.exists();
    }

    @Override
    public void create(boolean baseline) {
        this.session.lock(this.table, () -> {
            int retries = 0;
            while (!this.exists()) {
                if (retries == 0) {
                    LOG.info("Creating Schema History table " + this.table + (baseline ? " with baseline" : "") + " ...");
                }
                try {
                    ExecutionTemplateFactory.createExecutionTemplate(this.session.getJdbcConnection(), this.database).execute(() -> {
                        this.sqlScriptExecutorFactory.createSqlScriptExecutor(this.session.getJdbcConnection(), false).execute(this.database.getCreateScript(this.sqlScriptFactory, this.table, baseline));
                        LOG.debug("Created Schema History table " + this.table + (baseline ? " with baseline" : ""));
                        return null;
                    });
                }
                catch (MigrateDbException e) {
                    if (++retries >= 10) {
                        throw e;
                    }
                    try {
                        LOG.debug("Schema History table creation failed. Retrying in 1 sec ...");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw new MigrateDbException("Interrupted");
                    }
                }
            }
            return null;
        });
    }

    @Override
    public <T> T withLock(Callable<T> callable) {
        this.session.restoreOriginalState();
        return this.session.lock(this.table, callable);
    }

    @Override
    public void addAppliedMigration(int installedRank, Version version, String description, MigrationType type, String script, @Nullable Checksum checksum, int executionTime, boolean success) {
        boolean tableIsLocked = false;
        this.session.restoreOriginalState();
        if (!this.database.supportsDdlTransactions()) {
            this.table.lock();
            tableIsLocked = true;
        }
        try {
            String versionStr;
            String string = versionStr = version == null ? null : version.toString();
            if (!this.database.supportsEmptyMigrationDescription() && "".equals(description)) {
                description = "<< no description >>";
            }
            Object versionObj = versionStr == null ? JdbcNullTypes.StringNull : versionStr;
            Object checksumObj = checksum == null ? JdbcNullTypes.StringNull : checksum.toString();
            this.jdbcTemplate.update(this.database.getInsertStatement(this.table), installedRank, versionObj, description, type.name(), script, checksumObj, this.database.getInstalledBy(), executionTime, success);
            LOG.debug("Schema History table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to insert row for version '" + version + "' in Schema History table " + this.table, e);
        }
        finally {
            if (tableIsLocked) {
                this.table.unlock();
            }
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<AppliedMigration>();
        }
        this.refreshCache();
        return this.cache;
    }

    private void refreshCache() {
        int maxCachedInstalledRank = this.cache.isEmpty() ? -1 : this.cache.getLast().getInstalledRank();
        String query = this.database.getSelectStatement(this.table);
        try {
            this.cache.addAll(this.jdbcTemplate.query(query, rs -> {
                String type;
                Map<String, Integer> columnOrdinalMap = this.constructColumnOrdinalMap(rs);
                String checksum = rs.getString(columnOrdinalMap.get("checksum"));
                if (rs.wasNull()) {
                    checksum = null;
                }
                if ("SPRING_JDBC".equals(type = rs.getString(columnOrdinalMap.get("type")))) {
                    type = "JDBC";
                }
                return new AppliedMigration(rs.getInt(columnOrdinalMap.get("installed_rank")), rs.getString(columnOrdinalMap.get("version")) != null ? Version.parse(rs.getString(columnOrdinalMap.get("version"))) : null, rs.getString(columnOrdinalMap.get("description")), MigrationType.fromString(type), rs.getString(columnOrdinalMap.get("script")), checksum == null ? null : Checksum.parse(checksum), rs.getTimestamp(columnOrdinalMap.get("installed_on")), rs.getString(columnOrdinalMap.get("installed_by")), rs.getInt(columnOrdinalMap.get("execution_time")), rs.getBoolean(columnOrdinalMap.get("success")));
            }, maxCachedInstalledRank));
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error while retrieving the list of applied migrations from Schema History table " + this.table, e);
        }
    }

    private Map<String, Integer> constructColumnOrdinalMap(ResultSet rs) throws SQLException {
        HashMap<String, Integer> columnOrdinalMap = new HashMap<String, Integer>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnNameLower = metadata.getColumnName(i).toLowerCase(Locale.ROOT);
            columnOrdinalMap.put(columnNameLower, i);
        }
        return columnOrdinalMap;
    }

    @Override
    public boolean removeFailedMigrations(RepairResult repairResult, List<MigrationPattern> migrationPatternFilter) {
        if (!this.exists()) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary as table doesn't exist.");
            return false;
        }
        List<AppliedMigration> appliedMigrations = this.filterMigrations(this.allAppliedMigrations(), migrationPatternFilter);
        boolean failed = appliedMigrations.stream().anyMatch(am -> !am.isSuccess());
        if (!failed) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary. No failed migration detected.");
            return false;
        }
        try {
            appliedMigrations.stream().filter(am -> !am.isSuccess()).forEach(am -> repairResult.migrationsRemoved.add(CommandResultFactory.createRepairOutput(am)));
            for (AppliedMigration appliedMigration : appliedMigrations) {
                this.jdbcTemplate.execute("DELETE FROM " + this.table + " WHERE " + this.database.quote("success") + " = " + this.database.getBooleanFalse() + " AND " + (appliedMigration.getVersion() != null ? this.database.quote("version") + " = '" + appliedMigration.getVersion() + "'" : this.database.quote("description") + " = '" + appliedMigration.getDescription() + "'"), new Object[0]);
            }
            this.clearCache();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to repair Schema History table " + this.table, e);
        }
        return true;
    }

    private List<AppliedMigration> filterMigrations(List<AppliedMigration> appliedMigrations, List<MigrationPattern> migrationPatternFilter) {
        if (migrationPatternFilter == null || migrationPatternFilter.isEmpty()) {
            return appliedMigrations;
        }
        HashSet<AppliedMigration> filteredList = new HashSet<AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            for (MigrationPattern migrationPattern : migrationPatternFilter) {
                if (!migrationPattern.matches(appliedMigration.getVersion(), appliedMigration.getDescription())) continue;
                filteredList.add(appliedMigration);
            }
        }
        return new ArrayList<AppliedMigration>(filteredList);
    }

    @Override
    public void update(AppliedMigration appliedMigration, ResolvedMigration resolvedMigration) {
        this.session.restoreOriginalState();
        this.clearCache();
        Version version = appliedMigration.getVersion();
        String description = resolvedMigration.getDescription();
        Checksum checksum = resolvedMigration.getChecksum();
        MigrationType type = appliedMigration.getType().isExclusiveToAppliedMigrations() ? appliedMigration.getType() : resolvedMigration.getType();
        LOG.info("Repairing Schema History table for version " + version + " (Description: " + description + ", Type: " + type + ", Checksum: " + checksum + ")  ...");
        if (!this.database.supportsEmptyMigrationDescription() && "".equals(description)) {
            description = "<< no description >>";
        }
        Object checksumObj = checksum == null ? JdbcNullTypes.StringNull : checksum.toString();
        try {
            this.jdbcTemplate.update("UPDATE " + this.table + " SET " + this.database.quote("description") + "=? , " + this.database.quote("type") + "=? , " + this.database.quote("checksum") + "=? WHERE " + this.database.quote("installed_rank") + "=?", description, type.name(), checksumObj, appliedMigration.getInstalledRank());
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to repair Schema History table " + this.table + " for version " + version, e);
        }
    }

    @Override
    public void delete(AppliedMigration appliedMigration) {
        this.session.restoreOriginalState();
        this.clearCache();
        Version version = appliedMigration.getVersion();
        if (version == null) {
            LOG.info("Repairing Schema History table for description \"" + appliedMigration.getDescription() + "\" (Marking as DELETED)  ...");
        } else {
            LOG.info("Repairing Schema History table for version \"" + version + "\" (Marking as DELETED)  ...");
        }
        try {
            this.jdbcTemplate.update("UPDATE " + this.table + " SET " + this.database.quote("type") + "=?   WHERE " + this.database.quote("installed_rank") + "=?", "DELETED", appliedMigration.getInstalledRank());
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to repair Schema History table " + this.table + " for version " + version, e);
        }
    }
}

