/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.resource.filesystem.FileSystemResource;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileSystemResourceProvider
implements ResourceProvider {
    private final Path baseDir;

    public FileSystemResourceProvider(Path baseDir) {
        this.baseDir = baseDir.toAbsolutePath().normalize();
    }

    @Override
    public @Nullable Resource getResource(String name) {
        Path file = this.baseDir.resolve(name);
        if (Files.exists(file, new LinkOption[0])) {
            return new FileSystemResource(this.baseDir.resolve(name), this.baseDir);
        }
        return null;
    }

    @Override
    public Collection<Resource> getResources(final String prefix, final Collection<String> suffixes) {
        final ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            Files.walkFileTree(this.baseDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 100, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (Files.isHidden(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (StringUtils.startsAndEndsWith(file.getFileName().toString(), prefix, suffixes)) {
                        result.add(new FileSystemResource(file, FileSystemResourceProvider.this.baseDir));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new MigrateDbException("Failed to walk directory " + this.baseDir, e);
        }
        return result;
    }
}

