/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.resource.ResourceName;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.resource.ResourceNameParser;

public class ResourceNameValidator {
    private static final Log LOG = Log.getLog(ResourceNameValidator.class);

    public void validateSQLMigrationNaming(ResourceProvider provider, Configuration configuration) {
        ArrayList<String> errorsFound = new ArrayList<String>();
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (Resource resource : this.getAllSqlResources(provider, configuration)) {
            String filename = resource.getLastNameComponent();
            LOG.debug("Validating " + filename);
            ResourceName result = resourceNameParser.parse(filename);
            if (result.isValid()) continue;
            errorsFound.add(result.getValidityMessage());
        }
        if (!errorsFound.isEmpty()) {
            if (configuration.isValidateMigrationNaming()) {
                throw new MigrateDbException("Invalid SQL filenames found:\n" + String.join((CharSequence)"\n", errorsFound));
            }
            LOG.info(errorsFound.size() + " SQL migrations were detected but not run because they did not follow the filename convention.");
            LOG.info("If this is in error, enable debug logging or 'validateMigrationNaming' to fail fast and see a list of the invalid file names.");
        }
    }

    private Collection<Resource> getAllSqlResources(ResourceProvider provider, Configuration configuration) {
        return provider.getResources("", configuration.getSqlMigrationSuffixes());
    }
}

