/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class NameListResourceProvider
implements ResourceProvider {
    private final String[] names;

    public NameListResourceProvider(Collection<String> names) {
        this.names = (String[])names.toArray(String[]::new);
        Arrays.sort(this.names);
    }

    @Override
    public final @Nullable Resource getResource(String name) {
        int idx = Arrays.binarySearch(this.names, name);
        if (idx < 0) {
            return null;
        }
        return this.toResource(this.names[idx]);
    }

    @Override
    public final Collection<Resource> getResources(String prefix, Collection<String> suffixes) {
        return Arrays.stream(this.names).filter(it -> StringUtils.startsAndEndsWith(Resource.lastNameComponentOf(it), prefix, suffixes)).map(this::toResource).collect(Collectors.toList());
    }

    protected abstract Resource toResource(String var1);
}

