/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver.sql;

import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.resource.ResourceName;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.resolver.Context;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.parser.PlaceholderReplacingReader;
import migratedb.v1.core.internal.resolver.ChecksumCalculator;
import migratedb.v1.core.internal.resolver.ResolvedMigrationComparator;
import migratedb.v1.core.internal.resolver.ResolvedMigrationImpl;
import migratedb.v1.core.internal.resolver.sql.SqlMigrationExecutor;
import migratedb.v1.core.internal.resource.ResourceNameParser;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlMigrationResolver
implements MigrationResolver {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final ResourceProvider resourceProvider;
    private final SqlScriptFactory sqlScriptFactory;
    private final Configuration configuration;
    private final ParsingContext parsingContext;

    public SqlMigrationResolver(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration, ParsingContext parsingContext) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.resourceProvider = resourceProvider;
        this.sqlScriptFactory = sqlScriptFactory;
        this.configuration = configuration;
        this.parsingContext = parsingContext;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        List<String> suffixes = this.configuration.getSqlMigrationSuffixes();
        this.addMigrations(migrations, this.configuration.getSqlMigrationPrefix(), suffixes, false);
        this.addMigrations(migrations, this.configuration.getRepeatableSqlMigrationPrefix(), suffixes, true);
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }

    private List<Resource> createPlaceholderReplacingResources(List<Resource> resources) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (final Resource resource : resources) {
            Resource placeholderReplacingResource = new Resource(){

                @Override
                public String getName() {
                    return resource.getName();
                }

                @Override
                public Reader read(Charset charset) {
                    return PlaceholderReplacingReader.create(SqlMigrationResolver.this.configuration, SqlMigrationResolver.this.parsingContext, resource.read(charset));
                }

                @Override
                public String describeLocation() {
                    return resource.describeLocation();
                }

                public String toString() {
                    return resource.toString();
                }
            };
            list.add(placeholderReplacingResource);
        }
        return list;
    }

    private Checksum getChecksumForResource(boolean repeatable, List<Resource> resources, ResourceName resourceName) {
        if (repeatable && this.configuration.isPlaceholderReplacement()) {
            this.parsingContext.updateFilenamePlaceholder(resourceName);
            return ChecksumCalculator.calculate(this.createPlaceholderReplacingResources(resources), this.configuration);
        }
        return ChecksumCalculator.calculate(resources, this.configuration);
    }

    private @Nullable Checksum getEquivalentChecksumForResource(boolean repeatable, List<Resource> resources) {
        if (repeatable) {
            return ChecksumCalculator.calculate(resources, this.configuration);
        }
        return null;
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, List<String> suffixes, boolean repeatable) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (Resource resource : this.resourceProvider.getResources(prefix, suffixes)) {
            String filename = resource.getLastNameComponent();
            ResourceName resourceName = resourceNameParser.parse(filename);
            if (!resourceName.isValid() || SqlMigrationResolver.isSqlCallback(resourceName) || !prefix.equals(resourceName.getPrefix())) continue;
            SqlScript sqlScript = this.sqlScriptFactory.createSqlScript(resource, this.configuration.isMixed(), this.resourceProvider);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(resource);
            Checksum checksum = this.getChecksumForResource(repeatable, resources, resourceName);
            Checksum equivalentChecksum = this.getEquivalentChecksumForResource(repeatable, resources);
            boolean isBaseline = filename.startsWith(this.configuration.getBaselineMigrationPrefix());
            migrations.add(new ResolvedMigrationImpl(resourceName.getVersion(), resourceName.getDescription(), resource.getLastNameComponent(), checksum, equivalentChecksum, isBaseline ? MigrationType.SQL_BASELINE : MigrationType.SQL, resource.describeLocation(), new SqlMigrationExecutor(this.sqlScriptExecutorFactory, sqlScript)){});
        }
    }

    private static boolean isSqlCallback(ResourceName result) {
        return Event.fromId(result.getPrefix()) != null;
    }
}

