/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver.sql;

import java.sql.SQLException;
import migratedb.v1.core.api.executor.Context;
import migratedb.v1.core.api.executor.MigrationExecutor;
import migratedb.v1.core.api.internal.database.DatabaseExecutionStrategy;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScript sqlScript;

    SqlMigrationExecutor(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScript = sqlScript;
    }

    @Override
    public void execute(Context context) throws SQLException {
        DatabaseType databaseType = context.getConfiguration().getDatabaseTypeRegister().getDatabaseTypeForConnection(context.getConnection());
        DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
        strategy.execute(() -> {
            this.executeOnce(context);
            return true;
        });
    }

    private void executeOnce(Context context) {
        boolean outputQueryResults = false;
        this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection(), outputQueryResults).execute(this.sqlScript);
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.sqlScript.executeInTransaction();
    }

    @Override
    public boolean shouldExecute() {
        return this.sqlScript.shouldExecute();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{sqlScript=" + this.sqlScript + "}";
    }
}

