/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver.java;

import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.executor.MigrationExecutor;
import migratedb.v1.core.api.internal.database.DatabaseExecutionStrategy;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.migration.Context;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.internal.resource.ReaderResource;

public class JavaMigrationExecutor
implements MigrationExecutor {
    private final JavaMigration javaMigration;
    private final SqlScriptFactory sqlScriptFactory;
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;

    JavaMigrationExecutor(JavaMigration javaMigration, SqlScriptFactory sqlScriptFactory, SqlScriptExecutorFactory sqlScriptExecutorFactory) {
        this.javaMigration = javaMigration;
        this.sqlScriptFactory = sqlScriptFactory;
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
    }

    @Override
    public void execute(migratedb.v1.core.api.executor.Context context) throws SQLException {
        DatabaseType databaseType = context.getConfiguration().getDatabaseTypeRegister().getDatabaseTypeForConnection(context.getConnection());
        DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
        strategy.execute(() -> {
            this.executeOnce(context);
            return true;
        });
    }

    private void executeOnce(final migratedb.v1.core.api.executor.Context context) throws SQLException {
        try {
            this.javaMigration.migrate(new Context(){

                @Override
                public Configuration getConfiguration() {
                    return context.getConfiguration();
                }

                @Override
                public Connection getConnection() {
                    return context.getConnection();
                }

                @Override
                public void runScript(Reader script) {
                    ReaderResource resource = new ReaderResource("script", script);
                    SqlScript sqlScript = JavaMigrationExecutor.this.sqlScriptFactory.createSqlScript(resource, context.getConfiguration().isMixed(), ResourceProvider.noResources());
                    JavaMigrationExecutor.this.sqlScriptExecutorFactory.createSqlScriptExecutor(this.getConnection(), this.getConfiguration().isOutputQueryResults()).execute(sqlScript);
                }
            });
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new MigrateDbException("Migration failed !", e);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.javaMigration.canExecuteInTransaction();
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{javaMigration=" + this.javaMigration + "}";
    }
}

