/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver;

import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MigrationInfoHelper {
    private MigrationInfoHelper() {
    }

    public static VersionAndDescription extractVersionAndDescription(String migrationName, String prefix, String separator, boolean repeatable) {
        String description;
        String version;
        int separatorPos = migrationName.indexOf(separator);
        if (separatorPos < 0) {
            version = migrationName.substring(prefix.length());
            description = "";
        } else {
            version = migrationName.substring(prefix.length(), separatorPos);
            description = migrationName.substring(separatorPos + separator.length()).replace("_", " ");
        }
        if (StringUtils.hasText(version)) {
            if (repeatable) {
                throw new MigrateDbException("Wrong repeatable migration name format: " + migrationName + " (It cannot contain a version and should look like this: " + prefix + separator + description + ")");
            }
            try {
                return new VersionAndDescription(Version.parse(version), description);
            }
            catch (RuntimeException e) {
                throw new MigrateDbException("Wrong versioned migration name format: " + migrationName + " (could not recognise version number " + version + ")", e);
            }
        }
        if (!repeatable) {
            throw new MigrateDbException("Wrong versioned migration name format: " + migrationName + " (It must contain a version and should look like this: " + prefix + "1.2" + separator + description + ")");
        }
        return new VersionAndDescription(null, description);
    }

    public static final class VersionAndDescription {
        public final @Nullable Version version;
        public final String description;

        public VersionAndDescription(@Nullable Version version, String description) {
            this.version = version;
            this.description = description;
        }
    }
}

