/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import migratedb.v1.core.api.logging.LogSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum JavaUtilLogSystem implements LogSystem
{
    INSTANCE;


    private Logger logger(String logName) {
        return Logger.getLogger(logName);
    }

    @Override
    public boolean isDebugEnabled(String logName) {
        return this.logger(logName).isLoggable(Level.FINE);
    }

    @Override
    public void debug(String logName, String message) {
        this.log(this.logger(logName), Level.FINE, message, null);
    }

    @Override
    public void info(String logName, String message) {
        this.log(this.logger(logName), Level.INFO, message, null);
    }

    @Override
    public void warn(String logName, String message) {
        this.log(this.logger(logName), Level.WARNING, message, null);
    }

    @Override
    public void error(String logName, String message) {
        this.log(this.logger(logName), Level.SEVERE, message, null);
    }

    @Override
    public void error(String logName, String message, Exception e) {
        this.log(this.logger(logName), Level.SEVERE, message, e);
    }

    private void log(Logger logger, Level level, String message, @Nullable Exception e) {
        LogRecord record = new LogRecord(level, message);
        record.setLoggerName(logger.getName());
        record.setThrown(e);
        record.setSourceClassName(logger.getName());
        record.setSourceMethodName(this.getMethodName(logger));
        logger.log(record);
    }

    private @Nullable String getMethodName(Logger logger) {
        StackTraceElement[] steArray;
        for (StackTraceElement stackTraceElement : steArray = new Throwable().getStackTrace()) {
            if (!logger.getName().equals(stackTraceElement.getClassName())) continue;
            return stackTraceElement.getMethodName();
        }
        return null;
    }

    public String toString() {
        return "java.util.logging";
    }
}

