/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.jdbc.JdbcUtils;

public class JdbcConnectionFactoryImpl
implements JdbcConnectionFactory,
AutoCloseable {
    private final ConnectionProvider dataSource;
    private final int connectRetries;
    private final int connectRetriesInterval;
    private final Configuration configuration;
    private final DatabaseType databaseType;
    private final String jdbcUrl;
    private final String driverInfo;
    private final String productName;
    private Connection firstConnection;
    private JdbcConnectionFactory.ConnectionInitializer connectionInitializer;

    public JdbcConnectionFactoryImpl(ConnectionProvider dataSource, Configuration configuration) {
        this.dataSource = dataSource;
        this.connectRetries = configuration.getConnectRetries();
        this.connectRetriesInterval = configuration.getConnectRetriesInterval();
        this.configuration = configuration;
        this.firstConnection = JdbcUtils.openConnection(dataSource, this.connectRetries, this.connectRetriesInterval, configuration.getDatabaseTypeRegister());
        try {
            this.databaseType = configuration.getDatabaseTypeRegister().getDatabaseTypeForConnection(this.firstConnection);
            DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(this.firstConnection);
            this.jdbcUrl = JdbcConnectionFactoryImpl.getJdbcUrl(databaseMetaData);
            this.driverInfo = JdbcConnectionFactoryImpl.getDriverInfo(databaseMetaData);
            this.productName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        }
        catch (Error | RuntimeException e) {
            JdbcUtils.closeConnection(this.firstConnection);
            throw e;
        }
    }

    public void setConnectionInitializer(JdbcConnectionFactory.ConnectionInitializer connectionInitializer) {
        this.connectionInitializer = connectionInitializer;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getDriverInfo() {
        return this.driverInfo;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public Connection openConnection() throws MigrateDbException {
        Connection connection = this.firstConnection == null ? JdbcUtils.openConnection(this.dataSource, this.connectRetries, this.connectRetriesInterval, this.configuration.getDatabaseTypeRegister()) : this.firstConnection;
        this.firstConnection = null;
        try {
            this.databaseType.alterConnectionAsNeeded(connection, this.configuration);
            if (this.connectionInitializer != null) {
                this.connectionInitializer.initialize(this, connection);
            }
        }
        catch (Error | RuntimeException e) {
            block5: {
                try {
                    connection.close();
                }
                catch (Error | RuntimeException | SQLException suppressed) {
                    if (e.equals(suppressed)) break block5;
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
        return connection;
    }

    private static String getJdbcUrl(DatabaseMetaData databaseMetaData) {
        String url;
        try {
            url = databaseMetaData.getURL();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to retrieve the JDBC connection URL!", e);
        }
        if (url == null) {
            return "";
        }
        return JdbcConnectionFactoryImpl.filterUrl(url);
    }

    private static String filterUrl(String url) {
        int questionMark = url.indexOf("?");
        if (questionMark >= 0 && !url.contains("?databaseName=")) {
            url = url.substring(0, questionMark);
        }
        url = url.replaceAll("://.*:.*@", "://");
        return url;
    }

    private static String getDriverInfo(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to read database driver info: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        JdbcUtils.closeConnection(this.firstConnection);
    }
}

