/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.internal.info.ValidationMatch;

public final class ValidationContext {
    private final EnumSet<ValidationMatch> allowed;

    public static ValidationContext allAllowed() {
        return new ValidationContext(ValidationMatch.values());
    }

    public ValidationContext(Configuration configuration) {
        this(ValidationContext.getAllowedValidationMatches(configuration));
    }

    private static EnumSet<ValidationMatch> getAllowedValidationMatches(Configuration configuration) {
        EnumSet<ValidationMatch> result = EnumSet.noneOf(ValidationMatch.class);
        ((Stream)Map.of(ValidationMatch.OUT_OF_ORDER, configuration.isOutOfOrder(), ValidationMatch.MISSING, configuration.isIgnoreMissingMigrations(), ValidationMatch.PENDING, configuration.isIgnorePendingMigrations(), ValidationMatch.FUTURE, configuration.isIgnoreFutureMigrations(), ValidationMatch.IGNORED, configuration.isIgnoreFutureMigrations()).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).sequential()).forEach(result::add);
        return result;
    }

    public ValidationContext(ValidationMatch ... allowed) {
        this.allowed = EnumSet.noneOf(ValidationMatch.class);
        this.allowed.addAll(Arrays.asList(allowed));
    }

    public ValidationContext(EnumSet<ValidationMatch> allowed) {
        this.allowed = EnumSet.copyOf(allowed);
    }

    private ValidationContext(EnumSet<ValidationMatch> allowed, boolean doNotCopy) {
        assert (doNotCopy);
        this.allowed = allowed;
    }

    boolean allows(ValidationMatch f) {
        return this.allowed.contains((Object)f);
    }

    public ValidationContext with(ValidationMatch match, boolean allow) {
        EnumSet<ValidationMatch> newAllowed = EnumSet.copyOf(this.allowed);
        if (allow) {
            newAllowed.add(match);
        } else {
            newAllowed.remove((Object)match);
        }
        return new ValidationContext(newAllowed, true);
    }
}

