/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.MigrationState;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.info.MigrationInfoImpl;
import migratedb.v1.core.internal.info.NavigableMigrations;
import migratedb.v1.core.internal.info.NavigableMigrationsBuilder;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.info.VersionContext;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RefreshHelper {
    private final List<MigrationPattern> cherryPick;
    private final TargetVersion target;
    private final ValidationContext validationContext;
    private final NavigableMigrations migrations;

    RefreshHelper(Collection<ResolvedMigration> resolvedMigrations, Collection<AppliedMigration> appliedMigrations, List<MigrationPattern> cherryPick, TargetVersion target, ValidationContext validationContext) {
        this.cherryPick = cherryPick;
        this.target = target;
        this.validationContext = validationContext;
        this.migrations = new NavigableMigrationsBuilder(resolvedMigrations, appliedMigrations).build();
    }

    List<MigrationInfo> getMigrationInfo() {
        AppliedMigration currentApplied = this.migrations.latestAppliedVersioned().orElse(null);
        ResolvedMigration latestResolved = this.migrations.latestResolvedVersioned().orElse(null);
        ResolvedMigration nextResolved = this.resolvedIncrementalAfter(currentApplied).orElse(null);
        Version resolvedTarget = this.resolveTarget(currentApplied, latestResolved, nextResolved).orElse(null);
        ResolvedMigration pendingBaselineMigration = this.findPendingBaselineMigration(currentApplied, resolvedTarget).orElse(null);
        Version maxResolvedVersion = this.findMaxResolvedVersion(pendingBaselineMigration).orElse(null);
        Map<NavigableMigrations.VersionedMigrationEntry, MigrationState> versionedMigrationsWithState = this.computeStateOfVersionedMigrations(resolvedTarget, pendingBaselineMigration, maxResolvedVersion);
        Map<NavigableMigrations.RepeatableMigrationEntry, MigrationState> repeatableMigrationsWithState = this.computeStateOfRepeatableMigrations();
        return this.createSortedMigrationInfoList(pendingBaselineMigration, versionedMigrationsWithState, repeatableMigrationsWithState);
    }

    private Optional<Version> findMaxResolvedVersion(@Nullable ResolvedMigration pendingBaselineMigration) {
        return this.migrations.versionedMigrations.descendingMap().values().stream().filter(it -> it.resolvedIncrementalMigration != null || it.resolvedBaselineMigration != null && it.resolvedBaselineMigration == pendingBaselineMigration).findFirst().map(it -> it.version);
    }

    private List<MigrationInfo> createSortedMigrationInfoList(ResolvedMigration pendingBaselineMigration, Map<NavigableMigrations.VersionedMigrationEntry, MigrationState> versionedMigrations, Map<NavigableMigrations.RepeatableMigrationEntry, MigrationState> repeatableMigrations) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        VersionContext versionContext = new VersionContext(this.migrations.baseline);
        versionedMigrations.forEach((entry, state) -> result.add(new MigrationInfoImpl(this.selectResolvedMigration((NavigableMigrations.VersionedMigrationEntry)entry, pendingBaselineMigration), entry.appliedMigration, this.validationContext, versionContext, (MigrationState)((Object)state), entry.shouldNotExecute())));
        repeatableMigrations.forEach((entry, state) -> {
            result.add(new MigrationInfoImpl(entry.resolvedMigration, entry.latestAppliedMigration, this.validationContext, versionContext, (MigrationState)((Object)state), entry.shouldNotExecute()));
            entry.supersededRuns.forEach(it -> result.add(new MigrationInfoImpl(entry.resolvedMigration, (AppliedMigration)it, this.validationContext, versionContext, MigrationState.SUPERSEDED, entry.shouldNotExecute())));
        });
        result.sort(MigrationInfo.executionOrder());
        return result;
    }

    private ResolvedMigration selectResolvedMigration(NavigableMigrations.VersionedMigrationEntry entry, ResolvedMigration pendingBaselineMigration) {
        if (pendingBaselineMigration != null && entry.resolvedBaselineMigration == pendingBaselineMigration) {
            return entry.resolvedBaselineMigration;
        }
        if (entry.resolvedIncrementalMigration != null) {
            return entry.resolvedIncrementalMigration;
        }
        return entry.resolvedBaselineMigration;
    }

    private Optional<ResolvedMigration> findPendingBaselineMigration(@Nullable AppliedMigration currentAppliedVersioned, @Nullable Version resolvedTarget) {
        if (currentAppliedVersioned != null) {
            return Optional.empty();
        }
        return this.migrations.versionedMigrations.descendingMap().values().stream().filter(it -> it.resolvedBaselineMigration != null && (resolvedTarget == null || resolvedTarget.compareTo(it.version) <= 0) && MigrationPattern.anyMatchOrEmpty(it.version, this.cherryPick)).findFirst().map(it -> it.resolvedBaselineMigration);
    }

    private Optional<ResolvedMigration> resolvedIncrementalAfter(@Nullable AppliedMigration currentApplied) {
        if (currentApplied == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.migrations.versionedMigrations.higherEntry(currentApplied.getVersion())).map(it -> ((NavigableMigrations.VersionedMigrationEntry)it.getValue()).resolvedIncrementalMigration);
    }

    private Map<NavigableMigrations.VersionedMigrationEntry, MigrationState> computeStateOfVersionedMigrations(@Nullable Version resolvedTarget, @Nullable ResolvedMigration pendingBaselineMigration, @Nullable Version maxResolvedVersion) {
        return this.migrations.versionedMigrations.values().stream().collect(Collectors.toMap(Function.identity(), it -> this.stateOfVersionedMigration(it.version, it.deleted, it.appliedMigration != null, it.appliedMigration != null && it.appliedMigration.isSuccess(), it.outOfOrder, it.resolvedBaselineMigration != null || it.resolvedIncrementalMigration != null, it.appliedMigration != null && it.appliedMigration.getType().equals((Object)MigrationType.BASELINE), resolvedTarget != null && it.version.compareTo(resolvedTarget) > 0, this.migrations.baseline != null && it.version.compareTo(this.migrations.baseline) < 0 || pendingBaselineMigration != null && it.version.compareTo(pendingBaselineMigration.getVersion()) < 0, it.shouldNotExecute(), !MigrationPattern.anyMatchOrEmpty(it.version, this.cherryPick), it.resolvedIncrementalMigration == null && it.resolvedBaselineMigration != null && (pendingBaselineMigration == null || !it.version.equals(pendingBaselineMigration.getVersion())), this.migrations.versionedMigrations.tailMap(it.version, false).values().stream().anyMatch(higher -> higher.appliedMigration != null), maxResolvedVersion == null || it.version.compareTo(maxResolvedVersion) > 0)));
    }

    private MigrationState stateOfVersionedMigration(Version version, boolean isDeleted, boolean isApplied, boolean isSuccess, boolean isOutOfOrder, boolean isAvailableLocally, boolean isBaselineMarker, boolean isAboveTarget, boolean isBelowBaseline, boolean shouldNotExecute, boolean isExcludedByCherryPick, boolean onlyNonApplicableBaselineAvailable, boolean higherVersionHasBeenApplied, boolean isFutureVersion) {
        if (shouldNotExecute || isExcludedByCherryPick) {
            return MigrationState.IGNORED;
        }
        if (isDeleted) {
            return MigrationState.DELETED;
        }
        if (isBaselineMarker) {
            return MigrationState.BASELINE;
        }
        if (isApplied && isSuccess) {
            if (isOutOfOrder) {
                return MigrationState.OUT_OF_ORDER;
            }
            if (isAvailableLocally) {
                return MigrationState.SUCCESS;
            }
            if (isFutureVersion) {
                return MigrationState.FUTURE_SUCCESS;
            }
            return MigrationState.MISSING_SUCCESS;
        }
        if (isApplied) {
            if (isAvailableLocally) {
                return MigrationState.FAILED;
            }
            if (isFutureVersion) {
                return MigrationState.FUTURE_FAILED;
            }
            return MigrationState.MISSING_FAILED;
        }
        if (isBelowBaseline) {
            return MigrationState.BELOW_BASELINE;
        }
        if (isAboveTarget) {
            return MigrationState.ABOVE_TARGET;
        }
        if (higherVersionHasBeenApplied) {
            return MigrationState.IGNORED;
        }
        if (onlyNonApplicableBaselineAvailable) {
            throw new MigrateDbException("Pending migration version " + version + " only exists as a baseline migration, but an incremental migration is required.");
        }
        return MigrationState.PENDING;
    }

    private Map<NavigableMigrations.RepeatableMigrationEntry, MigrationState> computeStateOfRepeatableMigrations() {
        return this.migrations.repeatableMigrations.values().stream().collect(Collectors.toMap(Function.identity(), it -> this.stateOfLatestRepeatableMigrationRun(it.deleted, it.latestAppliedMigration != null, it.latestAppliedMigration != null && it.latestAppliedMigration.isSuccess(), it.resolvedMigration != null, it.shouldNotExecute(), !MigrationPattern.anyMatchOrEmpty(it.description, this.cherryPick), it.resolvedMigration != null && it.latestAppliedMigration != null && !it.resolvedMigration.checksumMatches(it.latestAppliedMigration.getChecksum()))));
    }

    private MigrationState stateOfLatestRepeatableMigrationRun(boolean isDeleted, boolean isApplied, boolean isSuccess, boolean isAvailableLocally, boolean shouldNotExecute, boolean isExcludedByCherryPick, boolean isOutdated) {
        if (shouldNotExecute || isExcludedByCherryPick) {
            return MigrationState.IGNORED;
        }
        if (isDeleted) {
            return MigrationState.DELETED;
        }
        if (isSuccess && isOutdated) {
            return MigrationState.OUTDATED;
        }
        if (isApplied && isSuccess) {
            if (isAvailableLocally) {
                return MigrationState.SUCCESS;
            }
            return MigrationState.MISSING_SUCCESS;
        }
        if (isApplied) {
            if (isAvailableLocally) {
                return MigrationState.FAILED;
            }
            return MigrationState.MISSING_FAILED;
        }
        return MigrationState.PENDING;
    }

    private Optional<Version> resolveTarget(@Nullable AppliedMigration currentApplied, @Nullable ResolvedMigration latestResolved, @Nullable ResolvedMigration nextResolved) {
        if (this.target == null) {
            return Optional.empty();
        }
        return this.target.mapVersion(version -> version).orElseGet(Map.of(TargetVersion.CURRENT, () -> Optional.ofNullable(currentApplied).map(AppliedMigration::getVersion), TargetVersion.LATEST, () -> Optional.ofNullable(latestResolved).map(ResolvedMigration::getVersion), TargetVersion.NEXT, () -> Optional.ofNullable(nextResolved).map(ResolvedMigration::getVersion)));
    }
}

