/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.internal.util.AsciiTable;
import migratedb.v1.core.internal.util.DateTimeUtils;

public class MigrationInfoDumper {
    private MigrationInfoDumper() {
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos) {
        List<String> columns = Arrays.asList("Category", "Version", "Description", "Type", "Installed On", "State");
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            List<String> row = Arrays.asList(MigrationInfoDumper.getCategory(migrationInfo), MigrationInfoDumper.getVersionStr(migrationInfo), migrationInfo.getDescription(), migrationInfo.getType().name(), DateTimeUtils.formatDateAsIsoishString(migrationInfo.getInstalledOn()), migrationInfo.getState().getDisplayName());
            rows.add(row);
        }
        StringBuilder output = new StringBuilder();
        new AsciiTable(columns, rows, true, "", "No migrations found").render(output);
        return output.toString();
    }

    static String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isExclusiveToAppliedMigrations()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        return "Versioned";
    }

    private static String getVersionStr(MigrationInfo migrationInfo) {
        return migrationInfo.getVersion() == null ? "" : migrationInfo.getVersion().toString();
    }
}

