/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver;

import java.sql.SQLException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseTable;
import migratedb.v1.core.internal.database.sqlserver.SQLServerDatabase;
import migratedb.v1.core.internal.database.sqlserver.SQLServerSchema;

public class SQLServerTable
extends BaseTable {
    private final String databaseName;

    public SQLServerTable(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, SQLServerSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
        this.databaseName = databaseName;
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT CAST(CASE WHEN EXISTS(  SELECT 1 FROM " + this.getDatabase().quote(this.databaseName) + ".INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?) THEN 1 ELSE 0 END AS BIT)", this.getSchema().getName(), this.getName());
    }

    @Override
    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("select * from " + this + " WITH (TABLOCKX)", new Object[0]);
    }

    @Override
    public SQLServerDatabase getDatabase() {
        return (SQLServerDatabase)super.getDatabase();
    }

    @Override
    public String toString() {
        return this.getDatabase().quote(this.databaseName, this.getSchema().getName(), this.getName());
    }
}

