/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.sqlserver.SQLServerApplicationLockTemplate;
import migratedb.v1.core.internal.database.sqlserver.SQLServerDatabase;
import migratedb.v1.core.internal.database.sqlserver.SQLServerEngineEdition;
import migratedb.v1.core.internal.database.sqlserver.SQLServerSchema;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class SQLServerSession
extends BaseSession {
    protected final String originalDatabaseName;
    private final String originalAnsiNulls;
    private final boolean azure;
    private final SQLServerEngineEdition engineEdition;

    protected SQLServerSession(SQLServerDatabase database, Connection connection) {
        super(database, connection);
        try {
            this.originalDatabaseName = this.jdbcTemplate.queryForString("SELECT DB_NAME()", new String[0]);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine current database", e);
        }
        try {
            this.azure = "SQL Azure".equals(this.getJdbcTemplate().queryForString("SELECT CAST(SERVERPROPERTY('edition') AS VARCHAR)", new String[0]));
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine database edition.'", e);
        }
        try {
            this.engineEdition = SQLServerEngineEdition.fromCode(this.getJdbcTemplate().queryForInt("SELECT SERVERPROPERTY('engineedition')", new String[0]));
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine database engine edition.'", e);
        }
        try {
            this.originalAnsiNulls = this.azure ? null : this.jdbcTemplate.queryForString("DECLARE @ANSI_NULLS VARCHAR(3) = 'OFF';\nIF ( (32 & @@OPTIONS) = 32 ) SET @ANSI_NULLS = 'ON';\nSELECT @ANSI_NULLS AS ANSI_NULLS;", new String[0]);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine ANSI NULLS state", e);
        }
    }

    void setCurrentDatabase(String databaseName) throws SQLException {
        if (!this.azure) {
            this.jdbcTemplate.execute("USE " + this.getDatabase().quote(databaseName), new Object[0]);
        }
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SCHEMA_NAME()", new String[0]);
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        this.setCurrentDatabase(this.originalDatabaseName);
        if (!this.azure) {
            this.jdbcTemplate.execute("SET ANSI_NULLS " + this.originalAnsiNulls, new Object[0]);
        }
    }

    @Override
    public SQLServerSchema getSchema(String name) {
        return new SQLServerSchema(this.jdbcTemplate, this.getDatabase(), this.originalDatabaseName, name);
    }

    @Override
    public SQLServerDatabase getDatabase() {
        return (SQLServerDatabase)super.getDatabase();
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return new SQLServerApplicationLockTemplate(this, this.jdbcTemplate, this.originalDatabaseName, table.toString().hashCode()).execute(callable);
    }

    public Boolean isAzureConnection() {
        return this.azure;
    }

    public SQLServerEngineEdition getEngineEdition() {
        return this.engineEdition;
    }
}

