/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.sqlserver.SQLServerSession;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class SQLServerApplicationLockTemplate {
    private static final Log LOG = Log.getLog(SQLServerApplicationLockTemplate.class);
    private final SQLServerSession session;
    private final JdbcTemplate jdbcTemplate;
    private final String databaseName;
    private final String lockName;

    SQLServerApplicationLockTemplate(SQLServerSession session, JdbcTemplate jdbcTemplate, String databaseName, int discriminator) {
        this.session = session;
        this.jdbcTemplate = jdbcTemplate;
        this.databaseName = databaseName;
        this.lockName = "MigrateDb-" + discriminator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Callable<T> callable) {
        T t;
        try {
            this.session.setCurrentDatabase(this.databaseName);
            this.jdbcTemplate.execute("EXEC sp_getapplock @Resource = ?, @LockTimeout='3600000', @LockMode = 'Exclusive', @LockOwner = 'Session'", this.lockName);
            t = callable.call();
        }
        catch (SQLException e) {
            try {
                throw new MigrateDbSqlException("Unable to acquire SQL Server application lock", e);
                catch (Exception e2) {
                    RuntimeException rethrow;
                    if (e2 instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (e2 instanceof RuntimeException) {
                        rethrow = (RuntimeException)e2;
                        throw rethrow;
                    }
                    rethrow = new MigrateDbException(e2);
                    throw rethrow;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.session.setCurrentDatabase(this.databaseName);
                    this.jdbcTemplate.execute("EXEC sp_releaseapplock @Resource = ?, @LockOwner = 'Session'", this.lockName);
                    throw throwable;
                }
                catch (SQLException e3) {
                    LOG.error("Unable to release SQL Server application lock", e3);
                }
                throw throwable;
            }
        }
        try {
            this.session.setCurrentDatabase(this.databaseName);
            this.jdbcTemplate.execute("EXEC sp_releaseapplock @Resource = ?, @LockOwner = 'Session'", this.lockName);
            return t;
        }
        catch (SQLException e) {
            LOG.error("Unable to release SQL Server application lock", e);
        }
        return t;
    }
}

