/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.snowflake;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.snowflake.SnowflakeDatabase;
import migratedb.v1.core.internal.database.snowflake.SnowflakeSchema;

public class SnowflakeSession
extends BaseSession {
    private final String originalRole;

    SnowflakeSession(SnowflakeDatabase database, Connection connection) {
        super(database, connection);
        try {
            this.originalRole = this.jdbcTemplate.queryForString("SELECT CURRENT_ROLE()", new String[0]);
        }
        catch (SQLException e) {
            throw new MigrateDbException("Unable to determine current role", e);
        }
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        this.jdbcTemplate.execute("USE ROLE " + this.getDatabase().quote(this.originalRole), new Object[0]);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        String schemaName = this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA()", new String[0]);
        return schemaName != null ? schemaName : "PUBLIC";
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("USE SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public SnowflakeSchema getSchema(String name) {
        return new SnowflakeSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public SnowflakeDatabase getDatabase() {
        return (SnowflakeDatabase)super.getDatabase();
    }
}

