/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.saphana;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.saphana.SAPHANADatabase;
import migratedb.v1.core.internal.database.saphana.SAPHANASchema;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class SAPHANASession
extends BaseSession {
    private final boolean isCloud;

    SAPHANASession(SAPHANADatabase database, Connection connection) {
        super(database, connection);
        try {
            String build = this.jdbcTemplate.queryForString("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='build_branch'", new String[0]);
            this.isCloud = build.startsWith("fa/CE");
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine build edition", e);
        }
    }

    public boolean isCloudConnection() {
        return this.isCloud;
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA FROM DUMMY", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new SAPHANASchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public SAPHANADatabase getDatabase() {
        return (SAPHANADatabase)super.getDatabase();
    }
}

