/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.redshift.RedshiftDatabase;
import migratedb.v1.core.internal.database.redshift.RedshiftSchema;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.util.StringUtils;

public class RedshiftSession
extends BaseSession {
    RedshiftSession(RedshiftDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || this.originalSchemaNameOrSearchPath.startsWith(schema.getName() + ",") || !schema.exists()) {
                return;
            }
            if (StringUtils.hasText(this.originalSchemaNameOrSearchPath) && !"unset".equals(this.originalSchemaNameOrSearchPath)) {
                this.doChangeCurrentSchemaOrSearchPathTo(schema + "," + this.originalSchemaNameOrSearchPath);
            } else {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString());
            }
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if ("unset".equals(schema)) {
            schema = "";
        }
        this.jdbcTemplate.execute("SELECT set_config('search_path', ?, false)", schema);
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
        String searchPath = this.getCurrentSchemaNameOrSearchPath();
        if (!StringUtils.hasText(currentSchema) && !StringUtils.hasText(searchPath)) {
            throw new MigrateDbException("Unable to determine current schema as search_path is empty. Set the current schema in currentSchema parameter of the JDBC URL or in MigrateDB's schemas property.");
        }
        String schema = StringUtils.hasText(currentSchema) ? currentSchema : searchPath;
        return this.getSchema(schema);
    }

    @Override
    public RedshiftSchema getSchema(String name) {
        return new RedshiftSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public RedshiftDatabase getDatabase() {
        return (RedshiftDatabase)super.getDatabase();
    }
}

