/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.redshift;

import java.sql.Connection;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.internal.database.base.BaseDatabaseType;
import migratedb.v1.core.internal.database.redshift.RedshiftDatabase;
import migratedb.v1.core.internal.database.redshift.RedshiftParser;
import migratedb.v1.core.internal.parser.BaseParser;

public class RedshiftDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "Redshift";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("PostgreSQL")) {
            String selectVersionQueryOutput = RedshiftDatabaseType.getSelectVersionOutput(connection);
            if (databaseProductName.startsWith("PostgreSQL 8") && selectVersionQueryOutput.contains("Redshift")) {
                return true;
            }
        }
        return databaseProductName.startsWith("Redshift");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        return new RedshiftDatabase(configuration, jdbcConnectionFactory);
    }

    @Override
    public BaseParser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new RedshiftParser(configuration, parsingContext);
    }
}

