/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLAdvisoryLockTemplate;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLDatabase;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLSchema;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.util.StringUtils;

public class PostgreSQLSession
extends BaseSession {
    private final String originalRole;
    private final Configuration configuration;

    protected PostgreSQLSession(Configuration configuration, PostgreSQLDatabase database, Connection connection) {
        super(database, connection);
        this.configuration = configuration;
        try {
            this.originalRole = this.jdbcTemplate.queryForString("SELECT CURRENT_USER", new String[0]);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine current user", e);
        }
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        this.jdbcTemplate.execute("SET ROLE '" + this.originalRole + "'", new Object[0]);
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema", new String[0]);
        String searchPath = this.getCurrentSchemaNameOrSearchPath();
        if (!StringUtils.hasText(currentSchema) && !StringUtils.hasText(searchPath)) {
            throw new MigrateDbException("Unable to determine current schema as search_path is empty. Set the current schema in currentSchema parameter of the JDBC URL or in MigrateDB's schemas property.");
        }
        String schema = StringUtils.hasText(currentSchema) ? currentSchema : searchPath;
        return this.getSchema(schema);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || this.originalSchemaNameOrSearchPath.startsWith(schema.getName() + ",") || !schema.exists()) {
                return;
            }
            if (StringUtils.hasText(this.originalSchemaNameOrSearchPath)) {
                this.doChangeCurrentSchemaOrSearchPathTo(schema + "," + this.originalSchemaNameOrSearchPath);
            } else {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString());
            }
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SELECT set_config('search_path', ?, false)", schema);
    }

    @Override
    public PostgreSQLSchema getSchema(String name) {
        return new PostgreSQLSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public PostgreSQLDatabase getDatabase() {
        return (PostgreSQLDatabase)super.getDatabase();
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return new PostgreSQLAdvisoryLockTemplate(this.configuration, this.jdbcTemplate, table.toString().hashCode()).execute(callable);
    }
}

