/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.postgresql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLDatabase;
import migratedb.v1.core.internal.database.postgresql.PostgreSQLTable;

public class PostgreSQLSchema
extends BaseSchema {
    protected PostgreSQLSchema(JdbcTemplate jdbcTemplate, PostgreSQLDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM pg_namespace WHERE nspname=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n    SELECT c.oid FROM pg_catalog.pg_class c\n    JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = c.oid AND d.deptype = 'e'\n    WHERE  n.nspname = ? AND d.objid IS NULL AND c.relkind IN ('r', 'v', 'S', 't')\n  UNION ALL\n    SELECT t.oid FROM pg_catalog.pg_type t\n    JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = t.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL AND t.typcategory NOT IN ('A', 'C')\n  UNION ALL\n    SELECT p.oid FROM pg_catalog.pg_proc p\n    JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = p.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL\n)", this.name, this.name, this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<PostgreSQLTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t LEFT JOIN pg_depend dep ON dep.objid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid AND dep.deptype = 'e' WHERE table_schema=? AND table_type='BASE TABLE' AND dep.objid IS NULL AND NOT (SELECT EXISTS (SELECT inhrelid FROM pg_catalog.pg_inherits WHERE inhrelid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid))", this.name);
        ArrayList<PostgreSQLTable> tables = new ArrayList<PostgreSQLTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new PostgreSQLTable(this.jdbcTemplate, this.database(), this, tableName));
        }
        return tables;
    }

    @Override
    public PostgreSQLTable getTable(String tableName) {
        return new PostgreSQLTable(this.jdbcTemplate, this.database(), this, tableName);
    }

    private PostgreSQLDatabase database() {
        return (PostgreSQLDatabase)super.getDatabase();
    }
}

