/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.postgresql;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.strategy.RetryStrategy;

public class PostgreSQLAdvisoryLockTemplate {
    private static final Log LOG = Log.getLog(PostgreSQLAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final Configuration configuration;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    PostgreSQLAdvisoryLockTemplate(Configuration configuration, JdbcTemplate jdbcTemplate, int discriminator) {
        this.configuration = configuration;
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        RuntimeException rethrow = null;
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            rethrow = new MigrateDbSqlException("Unable to acquire PostgreSQL advisory lock", e);
            throw rethrow;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            rethrow = e instanceof RuntimeException ? (RuntimeException)e : new MigrateDbException(e);
            throw rethrow;
        }
        finally {
            this.unlock(rethrow);
        }
    }

    private void lock() throws SQLException {
        RetryStrategy strategy = new RetryStrategy(this.configuration.getLockRetryCount());
        strategy.doWithRetries(this::tryLock, "Interrupted while attempting to acquire PostgreSQL advisory lock", "Number of retries exceeded while attempting to acquire PostgreSQL advisory lock. Configure the number of retries with the 'lockRetryCount' configuration option.");
    }

    private boolean tryLock() throws SQLException {
        List<Boolean> results = this.jdbcTemplate.query("SELECT pg_try_advisory_lock(" + this.lockNum + ")", rs -> rs.getBoolean("pg_try_advisory_lock"), new Object[0]);
        return results.size() == 1 && results.get(0) != false;
    }

    private void unlock(RuntimeException rethrow) throws MigrateDbSqlException {
        try {
            boolean unlocked = this.jdbcTemplate.queryForBoolean("SELECT pg_advisory_unlock(" + this.lockNum + ")", new String[0]);
            if (!unlocked) {
                if (rethrow == null) {
                    throw new MigrateDbException("Unable to release PostgreSQL advisory lock");
                }
                LOG.error("Unable to release PostgreSQL advisory lock");
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                throw new MigrateDbSqlException("Unable to release PostgreSQL advisory lock", e);
            }
            LOG.error("Unable to release PostgreSQL advisory lock", e);
        }
    }
}

