/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.oracle.OracleDatabase;
import migratedb.v1.core.internal.database.oracle.OracleSchema;

public class OracleSession
extends BaseSession {
    OracleSession(OracleDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new OracleSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public OracleDatabase getDatabase() {
        return (OracleDatabase)super.getDatabase();
    }
}

