/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.oracle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.oracle.OracleDatabase;
import migratedb.v1.core.internal.database.oracle.OracleTable;

public class OracleSchema
extends BaseSchema {
    OracleSchema(JdbcTemplate jdbcTemplate, OracleDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    public boolean isSystem() throws SQLException {
        return this.getDatabase().getSystemSchemas().contains(this.name);
    }

    @Override
    protected OracleDatabase getDatabase() {
        return (OracleDatabase)super.getDatabase();
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.getDatabase().queryReturnsRows("SELECT * FROM ALL_USERS WHERE USERNAME = ?", this.name);
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return !ObjectType.supportedTypesExist(this.jdbcTemplate, this.getDatabase(), this);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE USER " + this.getDatabase().quote(this.name) + " IDENTIFIED BY " + this.getDatabase().quote("FFllyywwaayy00!!"), new Object[0]);
        this.jdbcTemplate.execute("GRANT RESOURCE TO " + this.getDatabase().quote(this.name), new Object[0]);
        this.jdbcTemplate.execute("GRANT UNLIMITED TABLESPACE TO " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<OracleTable> doAllTables() throws SQLException {
        List<String> tableNames = ObjectType.TABLE.getObjectNames(this.jdbcTemplate, this.getDatabase(), this);
        ArrayList<OracleTable> tables = new ArrayList<OracleTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new OracleTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new OracleTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    public static enum ObjectType {
        TABLE("TABLE"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                boolean referencePartitionedTablesExist = database.queryReturnsRows("SELECT * FROM ALL_PART_TABLES WHERE OWNER = ? AND PARTITIONING_TYPE = 'REFERENCE'", schema.getName());
                boolean xmlDbAvailable = database.isXmlDbAvailable();
                StringBuilder tablesQuery = new StringBuilder();
                tablesQuery.append("WITH TABLES AS (\n  SELECT TABLE_NAME, OWNER\n  FROM ALL_TABLES\n  WHERE OWNER = ?\n    AND (IOT_TYPE IS NULL OR IOT_TYPE NOT LIKE '%OVERFLOW%')\n    AND NESTED != 'YES'\n    AND SECONDARY != 'Y'\n");
                if (xmlDbAvailable) {
                    tablesQuery.append("  UNION ALL\n  SELECT TABLE_NAME, OWNER\n  FROM ALL_XML_TABLES\n  WHERE OWNER = ?\n    AND TABLE_NAME NOT LIKE 'BIN$________________________$_'\n");
                }
                tablesQuery.append(")\nSELECT t.TABLE_NAME\nFROM TABLES t\n");
                if (referencePartitionedTablesExist) {
                    tablesQuery.append("  LEFT JOIN ALL_PART_TABLES pt\n    ON t.OWNER = pt.OWNER\n   AND t.TABLE_NAME = pt.TABLE_NAME\n   AND pt.PARTITIONING_TYPE = 'REFERENCE'\n  LEFT JOIN ALL_CONSTRAINTS fk\n    ON pt.OWNER = fk.OWNER\n   AND pt.TABLE_NAME = fk.TABLE_NAME\n   AND pt.REF_PTN_CONSTRAINT_NAME = fk.CONSTRAINT_NAME\n   AND fk.CONSTRAINT_TYPE = 'R'\n  LEFT JOIN ALL_CONSTRAINTS puk\n    ON fk.R_OWNER = puk.OWNER\n   AND fk.R_CONSTRAINT_NAME = puk.CONSTRAINT_NAME\n   AND puk.CONSTRAINT_TYPE IN ('P', 'U')\n  LEFT JOIN TABLES p\n    ON puk.OWNER = p.OWNER\n   AND puk.TABLE_NAME = p.TABLE_NAME\nSTART WITH p.TABLE_NAME IS NULL\nCONNECT BY PRIOR t.TABLE_NAME = p.TABLE_NAME\nORDER BY LEVEL DESC");
                }
                int n = 1 + (xmlDbAvailable ? 1 : 0);
                Object[] params = new String[n];
                Arrays.fill(params, schema.getName());
                return jdbcTemplate.queryForStringList(tablesQuery.toString(), (String[])params);
            }
        }
        ,
        QUEUE_TABLE("QUEUE TABLE"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT QUEUE_TABLE FROM ALL_QUEUE_TABLES WHERE OWNER = ?", schema.getName());
            }
        }
        ,
        MATERIALIZED_VIEW_LOG("MATERIALIZED VIEW LOG"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT MASTER FROM ALL_MVIEW_LOGS WHERE LOG_OWNER = ?", schema.getName());
            }
        }
        ,
        INDEX("INDEX"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_TYPE NOT LIKE '%DOMAIN%'", schema.getName());
            }
        }
        ,
        DOMAIN_INDEX("INDEX"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT INDEX_NAME FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_TYPE LIKE '%DOMAIN%'", schema.getName());
            }
        }
        ,
        DOMAIN_INDEX_TYPE("INDEXTYPE"),
        OPERATOR("OPERATOR"),
        CLUSTER("CLUSTER"),
        VIEW("VIEW"),
        MATERIALIZED_VIEW("MATERIALIZED VIEW"),
        DIMENSION("DIMENSION"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT DIMENSION_NAME FROM ALL_DIMENSIONS WHERE OWNER = ?", schema.getName());
            }
        }
        ,
        SYNONYM("SYNONYM"),
        SEQUENCE("SEQUENCE"),
        PROCEDURE("PROCEDURE"),
        FUNCTION("FUNCTION"),
        PACKAGE("PACKAGE"),
        CONTEXT("CONTEXT"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return jdbcTemplate.queryForStringList("SELECT NAMESPACE FROM " + database.dbaOrAll("CONTEXT") + " WHERE SCHEMA = ?", schema.getName());
            }
        }
        ,
        TRIGGER("TRIGGER"),
        TYPE("TYPE"),
        JAVA_SOURCE("JAVA SOURCE"),
        JAVA_CLASS("JAVA CLASS"),
        JAVA_RESOURCE("JAVA RESOURCE"),
        LIBRARY("LIBRARY"),
        XML_SCHEMA("XML SCHEMA"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                if (!database.isXmlDbAvailable()) {
                    return Collections.emptyList();
                }
                return jdbcTemplate.queryForStringList("SELECT QUAL_SCHEMA_URL FROM " + database.dbaOrAll("XML_SCHEMAS") + " WHERE OWNER = ?", schema.getName());
            }
        }
        ,
        REWRITE_EQUIVALENCE("REWRITE EQUIVALENCE"),
        SQL_TRANSLATION_PROFILE("SQL TRANSLATION PROFILE"),
        MINING_MODEL("MINING MODEL"){

            @Override
            public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
                return super.getObjectNames(jdbcTemplate, database, schema);
            }
        }
        ,
        SCHEDULER_JOB("JOB"),
        SCHEDULER_PROGRAM("PROGRAM"),
        SCHEDULE("SCHEDULE"),
        SCHEDULER_CHAIN("CHAIN"),
        FILE_WATCHER("FILE WATCHER"),
        RULE_SET("RULE SET"),
        RULE("RULE"),
        EVALUATION_CONTEXT("EVALUATION CONTEXT"),
        FILE_GROUP("FILE GROUP");

        private final String name;

        private ObjectType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString().replace('_', ' ');
        }

        public List<String> getObjectNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
            return jdbcTemplate.queryForStringList("SELECT DISTINCT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER = ? AND OBJECT_TYPE = ?", schema.getName(), this.getName());
        }

        public static Set<String> getObjectTypeNames(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
            boolean xmlDbAvailable = database.isXmlDbAvailable();
            String query = "SELECT DISTINCT OBJECT_TYPE FROM " + database.dbaOrAll("OBJECTS") + " WHERE OWNER = ? UNION SELECT '" + MATERIALIZED_VIEW_LOG.getName() + "' FROM DUAL WHERE EXISTS(SELECT * FROM ALL_MVIEW_LOGS WHERE LOG_OWNER = ?) UNION SELECT '" + DIMENSION.getName() + "' FROM DUAL WHERE EXISTS(SELECT * FROM ALL_DIMENSIONS WHERE OWNER = ?) UNION SELECT '" + QUEUE_TABLE.getName() + "' FROM DUAL WHERE EXISTS(SELECT * FROM ALL_QUEUE_TABLES WHERE OWNER = ?) UNION SELECT '" + CONTEXT.getName() + "' FROM DUAL WHERE EXISTS(SELECT * FROM " + database.dbaOrAll("CONTEXT") + " WHERE SCHEMA = ?) " + (String)(xmlDbAvailable ? "UNION SELECT '" + XML_SCHEMA.getName() + "' FROM DUAL WHERE EXISTS(SELECT * FROM " + database.dbaOrAll("XML_SCHEMAS") + " WHERE OWNER = ?) " : "");
            Object[] params = new String[(int)query.chars().filter(it -> it == 63).count()];
            Arrays.fill(params, schema.getName());
            return new HashSet<String>(jdbcTemplate.queryForStringList(query, (String[])params));
        }

        public static boolean supportedTypesExist(JdbcTemplate jdbcTemplate, OracleDatabase database, OracleSchema schema) throws SQLException {
            HashSet<String> existingTypeNames = new HashSet<String>(ObjectType.getObjectTypeNames(jdbcTemplate, database, schema));
            return !existingTypeNames.isEmpty();
        }
    }
}

