/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.oracle;

import java.sql.Connection;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.internal.database.base.BaseDatabaseType;
import migratedb.v1.core.internal.database.oracle.OracleDatabase;
import migratedb.v1.core.internal.database.oracle.OracleParser;
import migratedb.v1.core.internal.database.oracle.OracleSqlScriptExecutor;
import migratedb.v1.core.internal.parser.BaseParser;

public class OracleDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Oracle");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        OracleDatabase.enableTnsnamesOraSupport();
        return new OracleDatabase(configuration, jdbcConnectionFactory);
    }

    @Override
    public BaseParser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new OracleParser(configuration, parsingContext);
    }

    @Override
    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, CallbackExecutor callbackExecutor) {
        OracleDatabaseType thisRef = this;
        return (connection, outputQueryResults) -> new OracleSqlScriptExecutor(new JdbcTemplate(connection, thisRef), callbackExecutor, outputQueryResults);
    }
}

