/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.mysql.mariadb;

import java.util.List;
import java.util.regex.Pattern;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.internal.database.mysql.MySQLParser;
import migratedb.v1.core.internal.parser.ParserContext;
import migratedb.v1.core.internal.parser.PeekingReader;
import migratedb.v1.core.internal.parser.StatementType;
import migratedb.v1.core.internal.parser.Token;

public class MariaDBParser
extends MySQLParser {
    private static final Pattern BEGIN_NOT_ATOMIC_REGEX = Pattern.compile("^BEGIN\\sNOT\\sATOMIC\\s.*END", 2);
    private static final StatementType BEGIN_NOT_ATOMIC_STATEMENT = new StatementType();

    public MariaDBParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext);
    }

    @Override
    protected StatementType detectStatementType(String simplifiedStatement, ParserContext context, PeekingReader reader) {
        if (BEGIN_NOT_ATOMIC_REGEX.matcher(simplifiedStatement).matches()) {
            return BEGIN_NOT_ATOMIC_STATEMENT;
        }
        return super.detectStatementType(simplifiedStatement, context, reader);
    }

    @Override
    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) {
        String keywordText = keyword.getText();
        if (MariaDBParser.lastTokenIs(tokens, context.getParensDepth(), "NOT") && "ATOMIC".equalsIgnoreCase(keywordText)) {
            context.increaseBlockDepth("");
        }
        if (context.getBlockDepth() > 0 && context.getStatementType() == BEGIN_NOT_ATOMIC_STATEMENT && keywordText.equalsIgnoreCase("END")) {
            context.decreaseBlockDepth();
        }
        super.adjustBlockDepth(context, tokens, keyword, reader);
    }
}

