/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.ignite.thin;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.ignite.thin.IgniteThinSession;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class IgniteThinDatabase
extends BaseDatabase {
    public IgniteThinDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected IgniteThinSession doGetSession(Connection connection) {
        return new IgniteThinSession(this, connection);
    }

    @Override
    protected Version determineVersion() {
        try {
            int buildId = this.getMainSession().getJdbcTemplate().queryForInt("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'", new String[0]);
            return Version.parse(super.determineVersion() + "." + buildId);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine Apache Ignite build ID", e);
        }
    }

    @Override
    public final void ensureSupported() {
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" VARCHAR(100),\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL,\n     PRIMARY KEY (\"installed_rank\")\n) WITH \"TEMPLATE=REPLICATED, BACKUPS=1,ATOMICITY=ATOMIC\";\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX IF NOT EXISTS \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");";
    }

    @Override
    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + table + " WHERE " + this.quote("type") + " != 'TABLE' AND " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    @Override
    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote("installed_rank") + ", " + this.quote("version") + ", " + this.quote("description") + ", " + this.quote("type") + ", " + this.quote("script") + ", " + this.quote("checksum") + ", " + this.quote("installed_by") + ", " + this.quote("installed_on") + ", " + this.quote("execution_time") + ", " + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, ?,?)";
    }

    @Override
    protected String doGetCurrentUser() {
        String userName;
        try {
            Field connPropsField = this.getMainSession().getJdbcConnection().getClass().getDeclaredField("connProps");
            connPropsField.setAccessible(true);
            Object connProps = connPropsField.get(this.getMainSession().getJdbcConnection());
            userName = (String)connProps.getClass().getMethod("getUsername", new Class[0]).invoke(connProps, new Object[0]);
            if (userName == null || userName.isEmpty()) {
                return "ignite";
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new MigrateDbException(e);
        }
        return userName;
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

