/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.hsqldb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.hsqldb.HSQLDBDatabase;
import migratedb.v1.core.internal.database.hsqldb.HSQLDBTable;

public class HSQLDBSchema
extends BaseSchema {
    HSQLDBSchema(JdbcTemplate jdbcTemplate, HSQLDBDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM information_schema.system_schemas WHERE table_schem=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() {
        return this.allTables().isEmpty();
    }

    @Override
    protected void doCreate() throws SQLException {
        String user = this.jdbcTemplate.queryForString("SELECT USER() FROM (VALUES(0))", new String[0]);
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name) + " AUTHORIZATION " + user, new Object[0]);
    }

    protected List<HSQLDBTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_SCHEM = ? AND TABLE_TYPE = 'TABLE'", this.name);
        ArrayList<HSQLDBTable> tables = new ArrayList<HSQLDBTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new HSQLDBTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    protected HSQLDBDatabase getDatabase() {
        return (HSQLDBDatabase)super.getDatabase();
    }

    @Override
    public Table getTable(String tableName) {
        return new HSQLDBTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

