/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.h2.H2Database;
import migratedb.v1.core.internal.database.h2.H2Table;
import migratedb.v1.core.internal.util.StringUtils;

public class H2Schema
extends BaseSchema {
    private final boolean requiresV2Metadata;

    H2Schema(JdbcTemplate jdbcTemplate, H2Database database, String name, boolean requiresV2Metadata) {
        super(jdbcTemplate, database, name);
        this.requiresV2Metadata = requiresV2Metadata;
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() {
        return this.allTables().isEmpty();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<H2Table> doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = " + (this.requiresV2Metadata ? "'BASE TABLE'" : "'TABLE'"));
        ArrayList<H2Table> tables = new ArrayList<H2Table>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new H2Table(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    protected H2Database getDatabase() {
        return (H2Database)super.getDatabase();
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "_NAME FROM INFORMATION_SCHEMA." + objectType + "S WHERE " + objectType + "_SCHEMA = ?";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, this.name);
    }

    @Override
    public Table getTable(String tableName) {
        return new H2Table(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

