/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.firebird;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.firebird.FirebirdDatabase;
import migratedb.v1.core.internal.database.firebird.FirebirdTable;

public class FirebirdSchema
extends BaseSchema {
    public FirebirdSchema(JdbcTemplate jdbcTemplate, FirebirdDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return true;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return 0 == this.jdbcTemplate.queryForInt("select count(*)\nfrom (\n  -- views and tables\n  select RDB$RELATION_NAME AS OBJECT_NAME\n  from RDB$RELATIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- stored procedures\n  select RDB$PROCEDURE_NAME\n  from RDB$PROCEDURES\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- triggers\n  select RDB$TRIGGER_NAME\n  from RDB$TRIGGERS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- functions\n  select RDB$FUNCTION_NAME\n  from RDB$FUNCTIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- sequences\n  select RDB$GENERATOR_NAME\n  from RDB$GENERATORS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- exceptions\n  select RDB$EXCEPTION_NAME\n  from RDB$EXCEPTIONS\n  where (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\n  union all\n  -- domains\n  select RDB$FIELD_NAME\n  from RDB$FIELDS\n  where RDB$FIELD_NAME not starting with 'RDB$'\n  and (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)\nunion all\n-- packages\nselect RDB$PACKAGE_NAME\nfrom RDB$PACKAGES\nwhere (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)) a", new String[0]);
    }

    @Override
    protected void doCreate() throws SQLException {
    }

    protected List<FirebirdTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("select RDB$RELATION_NAME as tableName\nfrom RDB$RELATIONS\nwhere RDB$VIEW_BLR is null\nand (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG = 0)", new String[0]);
        ArrayList<FirebirdTable> tables = new ArrayList<FirebirdTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(this.getTable(tableName));
        }
        return tables;
    }

    @Override
    public FirebirdTable getTable(String tableName) {
        return new FirebirdTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected FirebirdDatabase getDatabase() {
        return (FirebirdDatabase)super.getDatabase();
    }
}

