/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.derby.DerbyDatabase;
import migratedb.v1.core.internal.database.derby.DerbyTable;
import migratedb.v1.core.internal.util.StringUtils;

public class DerbySchema
extends BaseSchema {
    public DerbySchema(JdbcTemplate jdbcTemplate, DerbyDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM sys.sysschemas WHERE schemaname=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() {
        return this.allTables().isEmpty();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<DerbyTable> doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLETYPE='T'");
        ArrayList<DerbyTable> tables = new ArrayList<DerbyTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new DerbyTable(this.jdbcTemplate, this.database(), this, tableName));
        }
        return tables;
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "name FROM sys.sys" + objectType + "s WHERE schemaid in (SELECT schemaid FROM sys.sysschemas where schemaname = ?)";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, this.name);
    }

    @Override
    public DerbyTable getTable(String tableName) {
        return new DerbyTable(this.jdbcTemplate, this.database(), this, tableName);
    }

    private DerbyDatabase database() {
        return (DerbyDatabase)super.getDatabase();
    }
}

