/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.db2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.db2.DB2Database;
import migratedb.v1.core.internal.database.db2.DB2Table;

public class DB2Schema
extends BaseSchema {
    DB2Schema(JdbcTemplate jdbcTemplate, DB2Database database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT count(*) from (SELECT 1 FROM syscat.schemata WHERE schemaname=?)", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return this.jdbcTemplate.queryForInt("select count(*) from (select 1 from syscat.tables where tabschema = ? union select 1 from syscat.views where viewschema = ? union select 1 from syscat.sequences where seqschema = ? union select 1 from syscat.indexes where indschema = ? union select 1 from syscat.routines where ROUTINESCHEMA = ? union select 1 from syscat.triggers where trigschema = ? )", this.name, this.name, this.name, this.name, this.name, this.name) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    public List<DB2Table> findTables(String sqlQuery, String ... params) throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList(sqlQuery, params);
        ArrayList<DB2Table> tables = new ArrayList<DB2Table>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new DB2Table(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    protected List<DB2Table> doAllTables() throws SQLException {
        return this.findTables("select TABNAME from SYSCAT.TABLES where TYPE='T' and TABSCHEMA = ?", this.name);
    }

    @Override
    public Table getTable(String tableName) {
        return new DB2Table(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected DB2Database getDatabase() {
        return (DB2Database)super.getDatabase();
    }
}

