/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.cockroachdb;

import java.sql.SQLException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseTable;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBDatabase;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBSchema;

public class CockroachDBTable
extends BaseTable {
    private static final Log LOG = Log.getLog(CockroachDBTable.class);

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(this::doExistsOnce);
    }

    protected boolean doExistsOnce() throws SQLException {
        if (this.getSchema().cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", this.getSchema().getName(), this.getName());
        }
        if (!this.getSchema().hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", this.getSchema().getName(), this.getName());
        }
        String sql = "SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name like '%" + this.getName() + "%' and length(table_name) = length(?)\n)";
        return this.jdbcTemplate.queryForBoolean(sql, this.getSchema().getName(), this.getName());
    }

    @Override
    protected void doLock() throws SQLException {
        LOG.debug("Unable to lock " + this + " as CockroachDB does not support locking. No concurrent migration supported.");
    }

    @Override
    protected void doUnlock() {
    }

    @Override
    public CockroachDBSchema getSchema() {
        return (CockroachDBSchema)super.getSchema();
    }
}

