/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.bigquery.BigQueryDatabase;
import migratedb.v1.core.internal.database.bigquery.BigQueryTable;

public class BigQuerySchema
extends BaseSchema {
    BigQuerySchema(JdbcTemplate jdbcTemplate, BigQueryDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        try {
            return this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + this.getDatabase().quote(this.name) + ".INFORMATION_SCHEMA.TABLES", new String[0]) >= 0;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("NOT_FOUND")) {
                return false;
            }
            throw e;
        }
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return this.doExists() && this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + this.getDatabase().quote(this.name) + ".INFORMATION_SCHEMA.TABLES", new String[0]) + this.jdbcTemplate.queryForInt("SELECT COUNT(routine_name) FROM " + this.getDatabase().quote(this.name) + ".INFORMATION_SCHEMA.ROUTINES", new String[0]) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA IF NOT EXISTS " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<BigQueryTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM " + this.getDatabase().quote(this.name) + ".INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE'", new String[0]);
        ArrayList<BigQueryTable> tables = new ArrayList<BigQueryTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new BigQueryTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new BigQueryTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected BigQueryDatabase getDatabase() {
        return (BigQueryDatabase)super.getDatabase();
    }
}

