/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.jdbc.JdbcNullTypes;

public class BigQueryJdbcTemplate
extends JdbcTemplate {
    public BigQueryJdbcTemplate(Connection connection, DatabaseType databaseType) {
        super(connection, databaseType);
    }

    @Override
    protected PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                statement.setNull(i + 1, this.nullType);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setInt(i + 1, (Integer)params[i]);
                continue;
            }
            if (params[i] instanceof Boolean) {
                statement.setBoolean(i + 1, (Boolean)params[i]);
                continue;
            }
            if (params[i] instanceof String) {
                statement.setString(i + 1, params[i].toString());
                continue;
            }
            if (params[i] == JdbcNullTypes.StringNull) {
                statement.setNull(i + 1, 12);
                continue;
            }
            if (params[i] == JdbcNullTypes.IntegerNull) {
                statement.setNull(i + 1, 4);
                continue;
            }
            if (params[i] == JdbcNullTypes.BooleanNull) {
                statement.setNull(i + 1, 16);
                continue;
            }
            throw new MigrateDbException("Unhandled object of type '" + params[i].getClass().getName() + "'. ");
        }
        return statement;
    }
}

