/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.Connection;
import java.util.Locale;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.internal.database.base.BaseDatabaseType;
import migratedb.v1.core.internal.database.bigquery.BigQueryDatabase;
import migratedb.v1.core.internal.database.bigquery.BigQueryParser;
import migratedb.v1.core.internal.parser.BaseParser;

public class BigQueryDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "BigQuery";
    }

    @Override
    public int getNullType() {
        return 0;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.toLowerCase(Locale.ROOT).contains("bigquery");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        return new BigQueryDatabase(configuration, jdbcConnectionFactory);
    }

    @Override
    public BaseParser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new BigQueryParser(configuration, parsingContext);
    }
}

