/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.bigquery;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.bigquery.BigQuerySession;
import migratedb.v1.core.internal.util.StringUtils;

public class BigQueryDatabase
extends BaseDatabase {
    public BigQueryDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected BigQuerySession doGetSession(Connection connection) {
        return new BigQuerySession(this, connection);
    }

    @Override
    public final void ensureSupported() {
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    `installed_rank` INT64 NOT NULL,\n    `version` STRING,\n    `description` STRING NOT NULL,\n    `type` STRING NOT NULL,\n    `script` STRING NOT NULL,\n    `checksum` STRING,\n    `installed_by` STRING NOT NULL,\n    `installed_on` TIMESTAMP,\n    `execution_time` INT64 NOT NULL,\n    `success` BOOL NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    @Override
    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote("installed_rank") + ", " + this.quote("version") + ", " + this.quote("description") + ", " + this.quote("type") + ", " + this.quote("script") + ", " + this.quote("checksum") + ", " + this.quote("installed_by") + ", " + this.quote("installed_on") + ", " + this.quote("execution_time") + ", " + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP(), ?, ?)";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getMainSession().getJdbcTemplate().queryForString("SELECT SESSION_USER() as user;", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll(identifier, this.getCloseQuote(), this.getEscapedQuote()) + this.getCloseQuote();
    }

    @Override
    public String getOpenQuote() {
        return "`";
    }

    @Override
    public String getCloseQuote() {
        return "`";
    }

    @Override
    public String getEscapedQuote() {
        return "\\`";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    @Override
    public boolean usesSingleSession() {
        return true;
    }
}

