/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchemaObject;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.jdbc.JdbcUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BaseTable
extends BaseSchemaObject
implements Table {
    protected int lockDepth = 0;

    public BaseTable(JdbcTemplate jdbcTemplate, Database database, Schema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    public final boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to check whether table " + this + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(@Nullable Schema catalog, @Nullable Schema schema, String table, String ... tableTypes) throws SQLException {
        boolean found;
        String[] types = tableTypes;
        if (types.length == 0) {
            types = null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.getDatabase().getJdbcMetaData().getTables(catalog == null ? null : catalog.getName(), schema == null ? null : this.getSchema().getName(), table, types);
            found = resultSet.next();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return found;
    }

    @Override
    public void lock() {
        if (!this.exists()) {
            return;
        }
        try {
            this.doLock();
            ++this.lockDepth;
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to lock table " + this, e);
        }
    }

    protected abstract void doLock() throws SQLException;

    @Override
    public void unlock() {
        if (!this.exists() || this.lockDepth == 0) {
            return;
        }
        try {
            this.doUnlock();
            --this.lockDepth;
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to unlock table " + this, e);
        }
    }

    protected void doUnlock() throws SQLException {
    }
}

