/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.base;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.sqlscript.Delimiter;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.exception.MigrateDbUpgradeRequiredException;
import migratedb.v1.core.internal.jdbc.JdbcUtils;
import migratedb.v1.core.internal.resource.StringResource;
import migratedb.v1.core.internal.util.AbbreviationUtils;
import migratedb.v1.core.internal.util.StringUtils;

public abstract class BaseDatabase
implements Database {
    private static final Log LOG = Log.getLog(BaseDatabase.class);
    private final DatabaseMetaData jdbcMetaData;
    protected final DatabaseType databaseType;
    protected final Configuration configuration;
    protected final JdbcConnectionFactory jdbcConnectionFactory;
    protected final JdbcTemplate jdbcTemplate;
    private Session migrationConnection;
    private Session mainConnection;
    protected final Connection rawMainJdbcConnection;
    private Version version;
    private String installedBy;

    public BaseDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        this.databaseType = jdbcConnectionFactory.getDatabaseType();
        this.configuration = configuration;
        this.rawMainJdbcConnection = jdbcConnectionFactory.openConnection();
        try {
            this.jdbcMetaData = this.rawMainJdbcConnection.getMetaData();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to get metadata for connection", e);
        }
        this.jdbcTemplate = new JdbcTemplate(this.rawMainJdbcConnection, this.databaseType);
        this.jdbcConnectionFactory = jdbcConnectionFactory;
    }

    private Session getSession(Connection connection) {
        return this.doGetSession(connection);
    }

    protected abstract Session doGetSession(Connection var1);

    @Override
    public final Version getVersion() {
        if (this.version == null) {
            this.version = this.determineVersion();
        }
        return this.version;
    }

    protected final void ensureDatabaseIsRecentEnough(String oldestSupportedVersion) {
        if (!this.getVersion().isAtLeast(oldestSupportedVersion)) {
            throw new MigrateDbUpgradeRequiredException(this.databaseType, this.computeVersionDisplayName(this.getVersion()), this.computeVersionDisplayName(Version.parse(oldestSupportedVersion)));
        }
    }

    protected final void recommendMigrateDbUpgradeIfNecessary(String newestSupportedVersion) {
        if (this.getVersion().isNewerThan(newestSupportedVersion)) {
            this.recommendMigrateDbUpgrade(newestSupportedVersion);
        }
    }

    protected final void recommendMigrateDbUpgradeIfNecessaryForMajorVersion(String newestSupportedVersion) {
        if (this.getVersion().isMajorNewerThan(newestSupportedVersion)) {
            this.recommendMigrateDbUpgrade(newestSupportedVersion);
        }
    }

    private void recommendMigrateDbUpgrade(String newestSupportedVersion) {
        String message = "MigrateDB upgrade recommended: " + this.databaseType + " " + this.computeVersionDisplayName(this.getVersion()) + " is newer than this version of MigrateDB and has not been tested. The latest tested version of " + this.databaseType + " is " + newestSupportedVersion + ".";
        LOG.info(message);
    }

    protected String computeVersionDisplayName(Version version) {
        return version.toString();
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.SEMICOLON;
    }

    @Override
    public final String getCatalog() {
        try {
            return this.doGetCatalog();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error retrieving the database name", e);
        }
    }

    protected String doGetCatalog() throws SQLException {
        return this.getMainSession().getJdbcConnection().getCatalog();
    }

    @Override
    public final String getCurrentUser() {
        try {
            return this.doGetCurrentUser();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error retrieving the database user", e);
        }
    }

    protected String doGetCurrentUser() throws SQLException {
        return this.jdbcMetaData.getUserName();
    }

    @Override
    public final String quote(String ... identifiers) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result.append(".");
            }
            first = false;
            result.append(this.doQuote(identifier));
        }
        return result.toString();
    }

    protected String doQuote(String identifier) {
        return this.getOpenQuote() + identifier + this.getCloseQuote();
    }

    protected String getOpenQuote() {
        return "\"";
    }

    protected String getCloseQuote() {
        return "\"";
    }

    protected String getEscapedQuote() {
        return "";
    }

    @Override
    public String unQuote(String identifier) {
        String open = this.getOpenQuote();
        String close = this.getCloseQuote();
        if (!open.isEmpty() && !close.isEmpty() && identifier.startsWith(open) && identifier.endsWith(close)) {
            identifier = identifier.substring(open.length(), identifier.length() - close.length());
            if (!this.getEscapedQuote().isEmpty()) {
                identifier = StringUtils.replaceAll(identifier, this.getEscapedQuote(), close);
            }
        }
        return identifier;
    }

    @Override
    public boolean usesSingleSession() {
        return false;
    }

    @Override
    public DatabaseMetaData getJdbcMetaData() {
        return this.jdbcMetaData;
    }

    @Override
    public Session getMainSession() {
        if (this.mainConnection == null) {
            this.mainConnection = this.getSession(this.rawMainJdbcConnection);
        }
        return this.mainConnection;
    }

    @Override
    public Session getMigrationSession() {
        if (this.migrationConnection == null) {
            this.migrationConnection = this.usesSingleSession() ? this.getMainSession() : this.getSession(this.jdbcConnectionFactory.openConnection());
        }
        return this.migrationConnection;
    }

    protected Version determineVersion() {
        try {
            return Version.parse(this.jdbcMetaData.getDatabaseMajorVersion() + "." + this.jdbcMetaData.getDatabaseMinorVersion());
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine the major version of the database", e);
        }
    }

    @Override
    public final SqlScript getCreateScript(SqlScriptFactory sqlScriptFactory, Table table, boolean baseline) {
        return sqlScriptFactory.createSqlScript(new StringResource("", this.getRawCreateScript(table, baseline)), false, null);
    }

    @Override
    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote("installed_rank") + ", " + this.quote("version") + ", " + this.quote("description") + ", " + this.quote("type") + ", " + this.quote("script") + ", " + this.quote("checksum") + ", " + this.quote("installed_by") + ", " + this.quote("execution_time") + ", " + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public final String getBaselineStatement(Table table) {
        return String.format(this.getInsertStatement(table).replace("?", "%s"), 1, "'" + this.configuration.getBaselineVersion() + "'", "'" + AbbreviationUtils.abbreviateDescription(this.configuration.getBaselineDescription()) + "'", "'" + MigrationType.BASELINE + "'", "'" + AbbreviationUtils.abbreviateScript(this.configuration.getBaselineDescription()) + "'", "NULL", "'" + this.installedBy + "'", 0, this.getBooleanTrue());
    }

    @Override
    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + table + " WHERE " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    @Override
    public final String getInstalledBy() {
        if (this.installedBy == null) {
            this.installedBy = this.configuration.getInstalledBy() == null ? this.getCurrentUser() : this.configuration.getInstalledBy();
        }
        return this.installedBy;
    }

    @Override
    public void close() {
        if (this.mainConnection == null && this.migrationConnection == null) {
            if (this.rawMainJdbcConnection != null) {
                JdbcUtils.closeConnection(this.rawMainJdbcConnection);
            }
        } else if (this.mainConnection == this.migrationConnection) {
            this.mainConnection.close();
        } else {
            try {
                if (this.migrationConnection != null) {
                    this.migrationConnection.close();
                }
            }
            finally {
                if (this.mainConnection != null) {
                    this.mainConnection.close();
                }
            }
        }
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public boolean supportsEmptyMigrationDescription() {
        return true;
    }

    @Override
    public boolean supportsMultiStatementTransactions() {
        return true;
    }

    @Override
    public List<? extends Schema> getAllSchemas() {
        throw new UnsupportedOperationException("Getting all schemas not supported for " + this.getDatabaseType().getName());
    }
}

