/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.configuration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;

public final class FileOutputStreamFactory
implements Supplier<OutputStream> {
    private final Path file;

    public FileOutputStreamFactory(Path file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileOutputStreamFactory)) {
            return false;
        }
        FileOutputStreamFactory other = (FileOutputStreamFactory)o;
        return Objects.equals(this.file, other.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public OutputStream get() {
        try {
            Path parent = this.file.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return Files.newOutputStream(this.file, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

