/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.configuration;

import java.util.Locale;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;

public class ConfigurationValidator {
    public void validate(Configuration configuration) {
        if (configuration.getDataSource() == null) {
            throw new MigrateDbException("Unable to connect to the database, because no data source was configured", ErrorCode.CONFIGURATION);
        }
        for (String key : configuration.getPlaceholders().keySet()) {
            if (!key.toLowerCase(Locale.ENGLISH).startsWith("migratedb:")) continue;
            throw new MigrateDbException("Invalid placeholder ('migratedb:' prefix is reserved): " + key, ErrorCode.CONFIGURATION);
        }
    }
}

